/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.multiscreen;

import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.views.pfly.multiscreen.MultiScreenMenuBuilder;
import org.uberfire.client.views.pfly.multiscreen.MultiScreenView;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.MultiPartWidget;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.PartDefinition;

@Dependent
@Named(value="MultiScreenPartWidget")
@Templated
public class MultiScreenPartWidget
extends Composite
implements MultiPartWidget {
    @Inject
    @DataField(value="parts")
    HTMLDivElement content;
    @Inject
    ManagedInstance<MultiScreenView> multiScreenViews;
    @Inject
    PanelManager panelManager;
    @Inject
    MultiScreenMenuBuilder menuBuilder;
    private HashMap<PartDefinition, MultiScreenView> parts = new LinkedHashMap<PartDefinition, MultiScreenView>();

    public void setPresenter(WorkbenchPanelPresenter presenter) {
    }

    public void setDndManager(WorkbenchDragAndDropManager dndManager) {
    }

    public void clear() {
        this.multiScreenViews.destroyAll();
        this.parts.values().forEach(s -> this.content.removeChild((Node)s.getElement()));
        this.parts.clear();
    }

    public void addPart(WorkbenchPartPresenter.View view) {
        PartDefinition partDefinition = view.getPresenter().getDefinition();
        if (!this.parts.containsKey(partDefinition)) {
            MultiScreenView screen = (MultiScreenView)this.multiScreenViews.get();
            screen.setContent((IsWidget)view);
            screen.setTitle(view.getPresenter().getTitle());
            if (view.getPresenter().getTitleDecoration() != null) {
                screen.setTitleWidget(view.getPresenter().getTitleDecoration());
            }
            if (this.parts.isEmpty() && partDefinition.getParentPanel().getPosition() == null) {
                screen.disableClose();
            }
            screen.setCloseHandler(() -> this.panelManager.closePart(partDefinition));
            Optional.ofNullable(view.getPresenter().getMenus()).ifPresent(menus -> menus.getItems().stream().map(this.menuBuilder).forEachOrdered(e -> e.ifPresent(element -> screen.addMenus((HTMLElement)element))));
            this.content.appendChild((Node)screen.getElement());
            this.parts.put(partDefinition, screen);
        }
        this.selectPart(partDefinition);
    }

    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
        MultiScreenView screen = this.parts.get(part);
        if (screen != null) {
            screen.setTitle(title);
            if (titleDecoration != null) {
                screen.setTitleWidget(titleDecoration);
            }
        }
    }

    public boolean selectPart(PartDefinition part) {
        if (!this.parts.containsKey(part)) {
            return false;
        }
        this.parts.entrySet().forEach(e -> {
            if (((PartDefinition)e.getKey()).equals(part)) {
                ((MultiScreenView)e.getValue()).show();
            } else {
                ((MultiScreenView)e.getValue()).hide();
            }
        });
        return true;
    }

    public boolean remove(PartDefinition part) {
        MultiScreenView screen = this.parts.remove(part);
        if (screen == null) {
            return false;
        }
        this.multiScreenViews.destroy((Object)screen);
        this.content.removeChild((Node)screen.getElement());
        this.parts.values().stream().reduce((f, s) -> s).ifPresent(s -> s.show());
        return true;
    }

    public void setFocus(boolean hasFocus) {
    }

    public void addOnFocusHandler(Command doWhenFocused) {
    }

    public int getPartsSize() {
        return this.parts.size();
    }

    public Collection<PartDefinition> getParts() {
        return Collections.unmodifiableSet(this.parts.keySet());
    }

    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, BeforeSelectionEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public Widget asWidget() {
        return this;
    }

    public void onResize() {
    }
}

