/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;
import org.uberfire.java.nio.fs.jgit.manager.MemoizedFileSystemsSupplier;

public class JGitFileSystemsCache {
    final Map<String, Supplier<JGitFileSystem>> fileSystemsSuppliers = new ConcurrentHashMap<String, Supplier<JGitFileSystem>>();
    final Map<String, Supplier<JGitFileSystem>> memoizedSuppliers;

    public JGitFileSystemsCache(final JGitFileSystemProviderConfiguration config) {
        this.memoizedSuppliers = Collections.synchronizedMap(new LinkedHashMap<String, Supplier<JGitFileSystem>>(config.getJgitFileSystemsInstancesCache() + 1, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > config.getJgitFileSystemsInstancesCache();
            }
        });
    }

    public void addSupplier(String fsKey, Supplier<JGitFileSystem> createFSSupplier) {
        PortablePreconditions.checkNotNull((String)"fsKey", (Object)fsKey);
        PortablePreconditions.checkNotNull((String)"fsSupplier", createFSSupplier);
        this.fileSystemsSuppliers.putIfAbsent(fsKey, createFSSupplier);
        this.createMemoizedSupplier(fsKey, createFSSupplier);
    }

    Supplier<JGitFileSystem> createMemoizedSupplier(String fsKey, Supplier<JGitFileSystem> createFSSupplier) {
        Supplier<JGitFileSystem> memoizedFSSupplier = MemoizedFileSystemsSupplier.of(createFSSupplier);
        this.memoizedSuppliers.putIfAbsent(fsKey, memoizedFSSupplier);
        return memoizedFSSupplier;
    }

    public void remove(String fsName) {
        this.fileSystemsSuppliers.remove(fsName);
        this.memoizedSuppliers.remove(fsName);
    }

    public JGitFileSystem get(String fsName) {
        Supplier<JGitFileSystem> memoizedSupplier = this.memoizedSuppliers.get(fsName);
        if (memoizedSupplier != null) {
            return new JGitFileSystemProxy(fsName, memoizedSupplier);
        }
        if (this.fileSystemsSuppliers.get(fsName) != null) {
            Supplier<JGitFileSystem> newMemoizedSupplier = this.createMemoizedSupplier(fsName, this.fileSystemsSuppliers.get(fsName));
            return new JGitFileSystemProxy(fsName, newMemoizedSupplier);
        }
        return null;
    }

    public void clear() {
        this.memoizedSuppliers.clear();
        this.fileSystemsSuppliers.clear();
    }

    public boolean containsKey(String fsName) {
        return this.fileSystemsSuppliers.containsKey(fsName);
    }

    public Collection<String> getFileSystems() {
        return this.fileSystemsSuppliers.keySet();
    }

    public JGitFileSystemsCacheInfo getCacheInfo() {
        return new JGitFileSystemsCacheInfo();
    }

    public class JGitFileSystemsCacheInfo {
        public int fileSystemsCacheSize() {
            return JGitFileSystemsCache.this.memoizedSuppliers.size();
        }

        public Set<String> fileSystemsCacheKeys() {
            return JGitFileSystemsCache.this.memoizedSuppliers.keySet();
        }

        public String toString() {
            return "JGitFileSystemsCacheInfo{fileSystemsCacheSize[" + this.fileSystemsCacheSize() + "], fileSystemsCacheKeys[" + this.fileSystemsCacheKeys() + "]}";
        }
    }
}

