/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.WriteConfiguration;

public class CreateRepository {
    private final File repoDir;
    private final File hookDir;
    private final KetchLeaderCache leaders;

    public CreateRepository(File repoDir) {
        this(repoDir, null, null);
    }

    public CreateRepository(File repoDir, File hookDir) {
        this(repoDir, hookDir, null);
    }

    public CreateRepository(File repoDir, File hookDir, KetchLeaderCache leaders) {
        this.repoDir = repoDir;
        this.hookDir = hookDir;
        this.leaders = leaders;
    }

    public Optional<Git> execute() {
        try {
            org.eclipse.jgit.api.Git _git = org.eclipse.jgit.api.Git.init().setBare(true).setDirectory(this.repoDir).call();
            if (this.leaders != null) {
                new WriteConfiguration(_git.getRepository(), cfg -> {
                    cfg.setInt("core", null, "repositoryformatversion", 1);
                    cfg.setString("extensions", null, "refsStorage", "reftree");
                }).execute();
            }
            Repository repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.repoDir)).build();
            org.eclipse.jgit.api.Git git = new org.eclipse.jgit.api.Git(repo);
            if (this.hookDir != null) {
                File repoHookDir = new File(this.repoDir, "hooks");
                try {
                    FileUtils.copyDirectory((File)this.hookDir, (File)repoHookDir);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                for (File file : repoHookDir.listFiles()) {
                    if (file == null || !file.isFile()) continue;
                    file.setExecutable(true);
                }
            }
            return Optional.of(new GitImpl(git, this.leaders));
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }
}

