/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevCommit;
import org.uberfire.java.nio.fs.jgit.util.Git;

public class SimpleRefUpdateCommand {
    private final Git git;
    private final String name;
    private final RevCommit commit;

    public SimpleRefUpdateCommand(Git git, String branchName, RevCommit commit) {
        this.git = git;
        this.name = branchName;
        this.commit = commit;
    }

    public void execute() throws IOException, ConcurrentRefUpdateException {
        RevCommit headId = this.git.getLastCommit("refs/heads/" + this.name);
        RefUpdate ru = this.git.getRepository().updateRef("refs/heads/" + this.name);
        if (headId == null) {
            ru.setExpectedOldObjectId((AnyObjectId)ObjectId.zeroId());
        } else {
            ru.setExpectedOldObjectId((AnyObjectId)headId);
        }
        ru.setNewObjectId((AnyObjectId)this.commit.getId());
        ru.setRefLogMessage(this.commit.getShortMessage(), false);
        this.forceUpdate(ru, this.commit.getId());
    }

    private void forceUpdate(RefUpdate ru, ObjectId id) throws IOException, ConcurrentRefUpdateException {
        RefUpdate.Result rc = ru.forceUpdate();
        switch (rc) {
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                break;
            }
            case REJECTED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
            }
            default: {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, "HEAD", id.toString(), rc));
            }
        }
    }
}

