/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Error {
  public static double stackTraceLimit;

  public static native void captureStackTrace(JsObject error, Function constructor);

  public static native void captureStackTrace(JsObject error);

  public String description;
  public String fileName;
  public double lineNumber;
  public String message;
  public String name;
  public Object sourceURL;
  public String stack;

  public Error() {}

  public Error(Object message, Object file, Object line) {}

  public Error(Object message, Object file) {}

  public Error(Object message) {}
}
