/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, name = "String", namespace = JsPackage.GLOBAL)
public class JsString {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface LocaleCompareLocalesUnionType {
    @JsOverlay
    static LocaleCompareLocalesUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default String[] asStringArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }

    @JsOverlay
    default boolean isStringArray() {
      return (Object) this instanceof Object[];
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ReplaceRegexUnionType {
    @JsOverlay
    static ReplaceRegexUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default RegExp asRegExp() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRegExp() {
      return (Object) this instanceof RegExp;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ReplaceStrUnionType {
    @JsOverlay
    static ReplaceStrUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Function asFunction() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isFunction() {
      return (Object) this instanceof Function;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface SearchRegexpUnionType {
    @JsOverlay
    static SearchRegexpUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default RegExp asRegExp() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRegExp() {
      return (Object) this instanceof RegExp;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  public static native String fromCharCode(double... var_args);

  public static native String fromCodePoint(double codePoint, double... var_args);

  public static native String raw(ITemplateArray template, Object... var_args);

  public double length;

  public JsString() {}

  public JsString(Object str) {}

  public native String anchor();

  public native String big();

  public native String blink();

  public native String bold();

  public native String charAt(double index);

  public native double charCodeAt();

  public native double charCodeAt(double index);

  public native double codePointAt(double index);

  public native String concat(Object... var_args);

  public native boolean endsWith(String searchString, double position);

  public native boolean endsWith(String searchString);

  public native String fixed();

  public native String fontcolor(String color);

  public native String fontsize(double size);

  public native boolean includes(String searchString, double position);

  public native boolean includes(String searchString);

  public native double indexOf(String searchValue, double fromIndex);

  public native double indexOf(String searchValue);

  public native String italics();

  public native double lastIndexOf(String searchValue, double fromIndex);

  public native double lastIndexOf(String searchValue);

  public native String link(String hrefAttribute);

  public native double localeCompare(
      String compareString, LocaleCompareLocalesUnionType locales, JsObject options);

  public native double localeCompare(String compareString, LocaleCompareLocalesUnionType locales);

  @JsOverlay
  public final double localeCompare(String compareString, String locales, JsObject options) {
    return localeCompare(
        compareString, Js.<LocaleCompareLocalesUnionType>uncheckedCast(locales), options);
  }

  @JsOverlay
  public final double localeCompare(String compareString, String[] locales, JsObject options) {
    return localeCompare(
        compareString, Js.<LocaleCompareLocalesUnionType>uncheckedCast(locales), options);
  }

  @JsOverlay
  public final double localeCompare(String compareString, String locales) {
    return localeCompare(compareString, Js.<LocaleCompareLocalesUnionType>uncheckedCast(locales));
  }

  @JsOverlay
  public final double localeCompare(String compareString, String[] locales) {
    return localeCompare(compareString, Js.<LocaleCompareLocalesUnionType>uncheckedCast(locales));
  }

  public native double localeCompare(String compareString);

  public native String[] match(Object regexp);

  public native String normalize();

  public native String normalize(String form);

  public native String padEnd(double targetLength, String padString);

  public native String padEnd(double targetLength);

  public native String padStart(double targetLength, String padString);

  public native String padStart(double targetLength);

  public native String quote();

  public native String repeat(double count);

  @JsOverlay
  public final String replace(RegExp regex, Function str, String flags) {
    return replace(
        Js.<ReplaceRegexUnionType>uncheckedCast(regex),
        Js.<ReplaceStrUnionType>uncheckedCast(str),
        flags);
  }

  @JsOverlay
  public final String replace(RegExp regex, Function str) {
    return replace(
        Js.<ReplaceRegexUnionType>uncheckedCast(regex), Js.<ReplaceStrUnionType>uncheckedCast(str));
  }

  @JsOverlay
  public final String replace(RegExp regex, ReplaceStrUnionType str, String flags) {
    return replace(Js.<ReplaceRegexUnionType>uncheckedCast(regex), str, flags);
  }

  @JsOverlay
  public final String replace(RegExp regex, ReplaceStrUnionType str) {
    return replace(Js.<ReplaceRegexUnionType>uncheckedCast(regex), str);
  }

  @JsOverlay
  public final String replace(RegExp regex, String str, String flags) {
    return replace(
        Js.<ReplaceRegexUnionType>uncheckedCast(regex),
        Js.<ReplaceStrUnionType>uncheckedCast(str),
        flags);
  }

  @JsOverlay
  public final String replace(RegExp regex, String str) {
    return replace(
        Js.<ReplaceRegexUnionType>uncheckedCast(regex), Js.<ReplaceStrUnionType>uncheckedCast(str));
  }

  @JsOverlay
  public final String replace(ReplaceRegexUnionType regex, Function str, String flags) {
    return replace(regex, Js.<ReplaceStrUnionType>uncheckedCast(str), flags);
  }

  @JsOverlay
  public final String replace(ReplaceRegexUnionType regex, Function str) {
    return replace(regex, Js.<ReplaceStrUnionType>uncheckedCast(str));
  }

  public native String replace(ReplaceRegexUnionType regex, ReplaceStrUnionType str, String flags);

  public native String replace(ReplaceRegexUnionType regex, ReplaceStrUnionType str);

  @JsOverlay
  public final String replace(ReplaceRegexUnionType regex, String str, String flags) {
    return replace(regex, Js.<ReplaceStrUnionType>uncheckedCast(str), flags);
  }

  @JsOverlay
  public final String replace(ReplaceRegexUnionType regex, String str) {
    return replace(regex, Js.<ReplaceStrUnionType>uncheckedCast(str));
  }

  @JsOverlay
  public final String replace(String regex, Function str, String flags) {
    return replace(
        Js.<ReplaceRegexUnionType>uncheckedCast(regex),
        Js.<ReplaceStrUnionType>uncheckedCast(str),
        flags);
  }

  @JsOverlay
  public final String replace(String regex, Function str) {
    return replace(
        Js.<ReplaceRegexUnionType>uncheckedCast(regex), Js.<ReplaceStrUnionType>uncheckedCast(str));
  }

  @JsOverlay
  public final String replace(String regex, ReplaceStrUnionType str, String flags) {
    return replace(Js.<ReplaceRegexUnionType>uncheckedCast(regex), str, flags);
  }

  @JsOverlay
  public final String replace(String regex, ReplaceStrUnionType str) {
    return replace(Js.<ReplaceRegexUnionType>uncheckedCast(regex), str);
  }

  @JsOverlay
  public final String replace(String regex, String str, String flags) {
    return replace(
        Js.<ReplaceRegexUnionType>uncheckedCast(regex),
        Js.<ReplaceStrUnionType>uncheckedCast(str),
        flags);
  }

  @JsOverlay
  public final String replace(String regex, String str) {
    return replace(
        Js.<ReplaceRegexUnionType>uncheckedCast(regex), Js.<ReplaceStrUnionType>uncheckedCast(str));
  }

  @JsOverlay
  public final double search(RegExp regexp) {
    return search(Js.<SearchRegexpUnionType>uncheckedCast(regexp));
  }

  public native double search(SearchRegexpUnionType regexp);

  @JsOverlay
  public final double search(String regexp) {
    return search(Js.<SearchRegexpUnionType>uncheckedCast(regexp));
  }

  public native String slice(double begin, double end);

  public native String slice(double begin);

  public native String small();

  public native String[] split();

  public native String[] split(Object separator, double limit);

  public native String[] split(Object separator);

  public native boolean startsWith(String searchString, double position);

  public native boolean startsWith(String searchString);

  public native String strike();

  public native String sub();

  public native String substr(double start, double length);

  public native String substr(double start);

  public native String substring(double start, double end);

  public native String substring(double start);

  public native String sup();

  public native String toLocaleLowerCase();

  public native String toLocaleUpperCase();

  public native String toLowerCase();

  public native String toSource();

  public native String toString();

  public native String toUpperCase();

  public native String trim();

  public native String trimLeft();

  public native String trimRight();

  public native String valueOf();
}
