/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.JsObject;
import elemental2.promise.Promise;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Navigator {
  @JsFunction
  public interface WebkitGetUserMediaErrorCallbackFn {
    Object onInvoke(NavigatorUserMediaError p0);
  }

  @JsFunction
  public interface WebkitGetUserMediaSuccessCallbackFn {
    Object onInvoke(MediaStream p0);
  }

  public String appCodeName;
  public String appName;
  public String appVersion;
  public boolean cookieEnabled;
  public Geolocation geolocation;
  public String language;
  public MediaDevices mediaDevices;
  public MimeTypeArray mimeTypes;
  public boolean onLine;
  public String platform;
  public PluginArray plugins;
  public String product;
  public ServiceWorkerContainer serviceWorker;
  public String userAgent;

  public native Promise<BatteryManager> getBattery();

  public native boolean javaEnabled();

  public native void registerContentHandler(String mimeType, String url, String title);

  public native void registerProtocolHandler(String scheme, String url, String title);

  public native boolean taintEnabled();

  public native void unregisterContentHandler(String mimeType, String url);

  public native void unregisterProtocolHandler(String scheme, String url);

  public native void webkitGetUserMedia(
      JsObject constraints,
      WebkitGetUserMediaSuccessCallbackFn successCallback,
      WebkitGetUserMediaErrorCallbackFn errorCallback);

  public native void webkitGetUserMedia(
      JsObject constraints, WebkitGetUserMediaSuccessCallbackFn successCallback);
}
