/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface RTCIceServerInterface_ {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetUrlsUnionType {
    @JsOverlay
    static GetUrlsUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default String[] asStringArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }

    @JsOverlay
    default boolean isStringArray() {
      return (Object) this instanceof Object[];
    }
  }

  @JsProperty
  String getCredential();

  @JsProperty
  GetUrlsUnionType getUrls();

  @JsProperty
  String getUsername();

  @JsProperty
  void setCredential(String credential);

  @JsProperty
  void setUrls(GetUrlsUnionType urls);

  @JsOverlay
  default void setUrls(String urls) {
    setUrls(Js.<GetUrlsUnionType>uncheckedCast(urls));
  }

  @JsOverlay
  default void setUrls(String[] urls) {
    setUrls(Js.<GetUrlsUnionType>uncheckedCast(urls));
  }

  @JsProperty
  void setUsername(String username);
}
