/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.jboss.errai.ioc.client.api.EnabledByProperty;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.resources.i18n.WorkbenchConstants;
import org.uberfire.client.util.UserAgent;
import org.uberfire.client.workbench.LayoutSelection;
import org.uberfire.client.workbench.VFSServiceProxy;
import org.uberfire.client.workbench.WorkbenchCloseHandler;
import org.uberfire.client.workbench.WorkbenchCustomStandalonePerspectiveDefinition;
import org.uberfire.client.workbench.WorkbenchLayout;
import org.uberfire.client.workbench.events.ApplicationReadyEvent;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionManager;

@EntryPoint
@EnabledByProperty(value="uberfire.plugin.mode.active", negated=true)
public class Workbench {
    private final Set<Class<?>> startupBlockers = new HashSet();
    private final Set<String> headersToKeep = new HashSet<String>();
    private final WorkbenchCloseHandler workbenchCloseHandler = (WorkbenchCloseHandler)GWT.create(WorkbenchCloseHandler.class);
    @Inject
    LayoutSelection layoutSelection;
    @Inject
    private Event<ApplicationReadyEvent> appReady;
    private boolean isStandaloneMode = false;
    @Inject
    private ActivityBeansCache activityBeansCache;
    @Inject
    private SyncBeanManager iocManager;
    @Inject
    private PlaceManager placeManager;
    private final Command workbenchCloseCommand = new Command(){

        public void execute() {
            Workbench.this.placeManager.closeAllPlaces();
        }
    };
    @Inject
    private PermissionManager permissionManager;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private VFSServiceProxy vfsService;
    private WorkbenchLayout layout;
    @Inject
    private User identity;
    @Inject
    private ClientMessageBus bus;
    @Inject
    private Logger logger;
    private SessionInfo sessionInfo = null;
    @Inject
    private ManagedInstance<WorkbenchCustomStandalonePerspectiveDefinition> workbenchCustomStandalonePerspectiveDefinition;

    public void addStartupBlocker(Class<?> responsibleParty) {
        this.startupBlockers.add(responsibleParty);
        this.logger.info(responsibleParty.getName() + " is blocking workbench startup.");
    }

    public void removeStartupBlocker(Class<?> responsibleParty) {
        if (this.startupBlockers.remove(responsibleParty)) {
            this.logger.info(responsibleParty.getName() + " is no longer blocking startup.");
        } else {
            this.logger.info(responsibleParty.getName() + " tried to unblock startup, but it wasn't blocking to begin with!");
        }
        this.startIfNotBlocked();
    }

    void startIfNotBlocked() {
        this.logger.info(this.startupBlockers.size() + " workbench startup blockers remain.");
        if (this.startupBlockers.isEmpty()) {
            this.bootstrap();
        }
    }

    @AfterInitialization
    private void afterInit() {
        this.removeStartupBlocker(Workbench.class);
    }

    @PostConstruct
    private void earlyInit() {
        this.layout = this.layoutSelection.get();
        WorkbenchResources.INSTANCE.CSS().ensureInjected();
        Map windowParamMap = Window.Location.getParameterMap();
        this.isStandaloneMode = windowParamMap.containsKey("standalone");
        List headers = windowParamMap.getOrDefault("header", Collections.emptyList());
        this.headersToKeep.addAll(headers);
        this.addStartupBlocker(Workbench.class);
    }

    private void bootstrap() {
        this.logger.info("Starting workbench...");
        ((SessionInfoImpl)this.currentSession()).setId(this.bus.getSessionId());
        if (!this.isStandaloneMode) {
            PerspectiveActivity homePerspective = this.getHomePerspectiveActivity();
            this.appReady.fire((Object)new ApplicationReadyEvent());
            if (homePerspective != null) {
                this.layout.setMarginWidgets(this.isStandaloneMode, this.headersToKeep);
                this.layout.onBootstrap();
                this.addLayoutToRootPanel(this.layout);
                this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(homePerspective.getIdentifier()));
            } else {
                this.activityBeansCache.noOp();
                this.logger.warn("No home perspective available!");
            }
        } else {
            this.layout.setMarginWidgets(this.isStandaloneMode, this.headersToKeep);
            this.layout.onBootstrap();
            this.addLayoutToRootPanel(this.layout);
            this.handleStandaloneMode(Window.Location.getParameterMap());
        }
        this.addCloseHandler();
        Window.addResizeHandler(event -> this.layout.resizeTo(event.getWidth(), event.getHeight()));
        Scheduler.get().scheduleDeferred(() -> this.layout.onResize());
        this.notifyJSReady();
    }

    private void addCloseHandler() {
        if (UserAgent.isChrome()) {
            Window.addCloseHandler(event -> this.workbenchCloseHandler.onWindowClose(this.workbenchCloseCommand));
            Window.addWindowClosingHandler(event -> {
                if (!this.placeManager.canCloseAllPlaces()) {
                    event.setMessage(WorkbenchConstants.INSTANCE.closingWindowMessage());
                }
            });
        } else {
            Window.addWindowClosingHandler(event -> this.workbenchCloseHandler.onWindowClose(this.workbenchCloseCommand));
        }
    }

    private native void notifyJSReady();

    void handleStandaloneMode(Map<String, List<String>> parameters) {
        if (parameters.containsKey("perspective") && !parameters.get("perspective").isEmpty()) {
            this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(parameters.get("perspective").get(0)));
        } else if (parameters.containsKey("path") && !parameters.get("path").isEmpty()) {
            this.openStandaloneEditor(parameters);
        }
    }

    private void openStandaloneEditor(Map<String, List<String>> parameters) {
        String standalonePerspective = "StandaloneEditorPerspective";
        boolean openEditor = true;
        if (!this.workbenchCustomStandalonePerspectiveDefinition.isUnsatisfied()) {
            WorkbenchCustomStandalonePerspectiveDefinition workbenchCustomStandalonePerspectiveDefinition = (WorkbenchCustomStandalonePerspectiveDefinition)this.workbenchCustomStandalonePerspectiveDefinition.get();
            standalonePerspective = workbenchCustomStandalonePerspectiveDefinition.getStandalonePerspectiveIdentifier();
            openEditor = workbenchCustomStandalonePerspectiveDefinition.openPathAutomatically();
        }
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(standalonePerspective));
        if (openEditor) {
            this.vfsService.get(parameters.get("path").get(0), (ParameterizedCommand<Path>)((ParameterizedCommand)path -> {
                if (parameters.containsKey("editor") && !((List)parameters.get("editor")).isEmpty()) {
                    this.openEditor((Path)path, (String)((List)parameters.get("editor")).get(0));
                } else {
                    this.openEditor((Path)path);
                }
            }));
        }
    }

    void openEditor(Path path) {
        this.placeManager.goTo((PlaceRequest)new PathPlaceRequest(path));
    }

    void openEditor(Path path, String editor) {
        this.placeManager.goTo((PlaceRequest)new PathPlaceRequest(path, editor));
    }

    public PerspectiveActivity getHomePerspectiveActivity() {
        PerspectiveActivity homePerspective = null;
        AuthorizationPolicy authPolicy = this.permissionManager.getAuthorizationPolicy();
        String homePerspectiveId = authPolicy.getHomePerspective(this.identity);
        PerspectiveActivity defaultPerspective = null;
        Collection perspectives = this.iocManager.lookupBeans(PerspectiveActivity.class);
        for (SyncBeanDef perspective : perspectives) {
            PerspectiveActivity instance = (PerspectiveActivity)perspective.getInstance();
            if (homePerspectiveId != null && homePerspectiveId.equals(instance.getIdentifier())) {
                homePerspective = instance;
                if (defaultPerspective == null) continue;
                this.iocManager.destroyBean((Object)defaultPerspective);
                continue;
            }
            if (instance.isDefault()) {
                defaultPerspective = instance;
                continue;
            }
            this.iocManager.destroyBean((Object)instance);
        }
        return homePerspective != null ? homePerspective : defaultPerspective;
    }

    @Produces
    @ApplicationScoped
    private SessionInfo currentSession() {
        if (this.sessionInfo == null) {
            this.sessionInfo = new SessionInfoImpl(this.identity);
        }
        return this.sessionInfo;
    }

    void addLayoutToRootPanel(WorkbenchLayout layout) {
        RootLayoutPanel.get().add(layout.getRoot());
    }
}

