/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.ServerGmsImpl;
import org.jgroups.util.Digest;

public class ParticipantGmsImpl
extends ServerGmsImpl {
    private final Collection<Address> suspected_mbrs = new LinkedHashSet<Address>();

    public ParticipantGmsImpl(GMS g) {
        super(g);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.suspected_mbrs.clear();
    }

    @Override
    public void join(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void joinWithStateTransfer(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void leave(Address mbr) {
        Address coord = this.gms.determineCoordinator();
        if (coord != null) {
            this.sendLeaveReqTo(coord);
        }
        this.gms.becomeClient();
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        View v = join_rsp.getView();
        ViewId tmp_vid = v != null ? v.getViewId() : null;
        ViewId my_view = this.gms.getViewId();
        if (tmp_vid != null && my_view != null && tmp_vid.compareToIDs(my_view) > 0) {
            Digest d = join_rsp.getDigest();
            this.gms.installView(v, d);
        }
    }

    @Override
    public void suspect(Address mbr) {
        LinkedHashSet<GmsImpl.Request> suspected = new LinkedHashSet<GmsImpl.Request>(1);
        suspected.add(new GmsImpl.Request(3, mbr));
        this.handleMembershipChange(suspected);
    }

    @Override
    public void unsuspect(Address mbr) {
        if (mbr != null) {
            this.suspected_mbrs.remove(mbr);
        }
    }

    @Override
    public void handleMembershipChange(Collection<GmsImpl.Request> requests) {
        LinkedHashSet<Address> leaving_mbrs = new LinkedHashSet<Address>(requests.size());
        requests.forEach(r -> {
            if (r.type == 3) {
                this.suspected_mbrs.add(r.mbr);
            } else if (r.type == 2) {
                leaving_mbrs.add(r.mbr);
            }
        });
        if (this.suspected_mbrs.isEmpty() && leaving_mbrs.isEmpty()) {
            return;
        }
        if (this.wouldIBeCoordinator(leaving_mbrs)) {
            this.log.debug("%s: members are %s, coord=%s: I'm the new coordinator", this.gms.local_addr, this.gms.members, this.gms.local_addr);
            this.gms.becomeCoordinator();
            LinkedHashSet leavingOrSuspectedMembers = new LinkedHashSet();
            leaving_mbrs.forEach(mbr -> leavingOrSuspectedMembers.add(new GmsImpl.Request(2, (Address)mbr)));
            this.suspected_mbrs.forEach(mbr -> {
                leavingOrSuspectedMembers.add(new GmsImpl.Request(3, (Address)mbr));
                this.gms.ack_collector.suspect((Address)mbr);
            });
            this.suspected_mbrs.clear();
            this.gms.getViewHandler().add(leavingOrSuspectedMembers);
        }
    }

    @Override
    public void handleViewChange(View new_view, Digest digest) {
        this.suspected_mbrs.clear();
        if (this.leaving && !new_view.containsMember(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    boolean wouldIBeCoordinator(Collection<Address> leaving_mbrs) {
        List<Address> mbrs = this.gms.computeNewMembership(this.gms.members.getMembers(), null, leaving_mbrs, this.suspected_mbrs);
        if (mbrs.isEmpty()) {
            return false;
        }
        Address new_coord = mbrs.get(0);
        return this.gms.local_addr.equals(new_coord);
    }
}

