/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Double;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class JSONType {
  @JsFunction
  public interface ParseReviverCallbackFn {
    Object onInvoke(String p0, Object p1);
  }

  @JsFunction
  public interface StringifyReplacerCallbackFn {
    Object onInvoke(String p0, Object p1);
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface StringifyReplacerUnionType {
    @JsOverlay
    static StringifyReplacerUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default String[] asStringArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default StringifyReplacerCallbackFn asStringifyReplacerCallbackFn() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isStringArray() {
      return (Object) this instanceof Object[];
    }

    @JsOverlay
    default boolean isStringifyReplacerCallbackFn() {
      return (Object) this instanceof StringifyReplacerCallbackFn;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface StringifySpaceUnionType {
    @JsOverlay
    static StringifySpaceUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.castToDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  public native Object parse(String jsonStr, ParseReviverCallbackFn reviver);

  public native Object parse(String jsonStr);

  @JsOverlay
  public final String stringify(Object jsonObj, String[] replacer, String space) {
    return stringify(
        jsonObj,
        Js.<StringifyReplacerUnionType>uncheckedCast(replacer),
        Js.<StringifySpaceUnionType>uncheckedCast(space));
  }

  @JsOverlay
  public final String stringify(Object jsonObj, String[] replacer, StringifySpaceUnionType space) {
    return stringify(jsonObj, Js.<StringifyReplacerUnionType>uncheckedCast(replacer), space);
  }

  @JsOverlay
  public final String stringify(Object jsonObj, String[] replacer, double space) {
    return stringify(
        jsonObj,
        Js.<StringifyReplacerUnionType>uncheckedCast(replacer),
        Js.<StringifySpaceUnionType>uncheckedCast(space));
  }

  @JsOverlay
  public final String stringify(Object jsonObj, String[] replacer) {
    return stringify(jsonObj, Js.<StringifyReplacerUnionType>uncheckedCast(replacer));
  }

  @JsOverlay
  public final String stringify(
      Object jsonObj, StringifyReplacerCallbackFn replacer, String space) {
    return stringify(
        jsonObj,
        Js.<StringifyReplacerUnionType>uncheckedCast(replacer),
        Js.<StringifySpaceUnionType>uncheckedCast(space));
  }

  @JsOverlay
  public final String stringify(
      Object jsonObj, StringifyReplacerCallbackFn replacer, StringifySpaceUnionType space) {
    return stringify(jsonObj, Js.<StringifyReplacerUnionType>uncheckedCast(replacer), space);
  }

  @JsOverlay
  public final String stringify(
      Object jsonObj, StringifyReplacerCallbackFn replacer, double space) {
    return stringify(
        jsonObj,
        Js.<StringifyReplacerUnionType>uncheckedCast(replacer),
        Js.<StringifySpaceUnionType>uncheckedCast(space));
  }

  @JsOverlay
  public final String stringify(Object jsonObj, StringifyReplacerCallbackFn replacer) {
    return stringify(jsonObj, Js.<StringifyReplacerUnionType>uncheckedCast(replacer));
  }

  @JsOverlay
  public final String stringify(Object jsonObj, StringifyReplacerUnionType replacer, String space) {
    return stringify(jsonObj, replacer, Js.<StringifySpaceUnionType>uncheckedCast(space));
  }

  public native String stringify(
      Object jsonObj, StringifyReplacerUnionType replacer, StringifySpaceUnionType space);

  @JsOverlay
  public final String stringify(Object jsonObj, StringifyReplacerUnionType replacer, double space) {
    return stringify(jsonObj, replacer, Js.<StringifySpaceUnionType>uncheckedCast(space));
  }

  public native String stringify(Object jsonObj, StringifyReplacerUnionType replacer);

  public native String stringify(Object jsonObj);
}
