/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.spaces;

import java.net.URI;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class SpacesAPIImpl
implements SpacesAPI {
    private static final String PATH_PATTERN = "^[A-Za-z]+://[^@]+[@]([^/]+)/.*";
    private static final Pattern PATH_REGEX = Pattern.compile("^[A-Za-z]+://[^@]+[@]([^/]+)/.*");

    public Space getSpace(String name) {
        if ("system".equals(name)) {
            return this.getDefaultSpace();
        }
        return new Space(name);
    }

    public Optional<Space> resolveSpace(String uri) {
        return Optional.ofNullable(PATH_REGEX.matcher(uri)).filter(matcher -> matcher.matches()).map(matcher -> matcher.group(1)).map(name -> this.trimName((String)name)).map(this::getSpace);
    }

    private String trimName(String name) {
        if (name.contains("@")) {
            return name.substring(name.indexOf("@") + 1);
        }
        return name;
    }

    public URI resolveFileSystemURI(SpacesAPI.Scheme scheme, Space space, String fsName) {
        URI uri = URI.create(SpacesAPI.resolveFileSystemPath((SpacesAPI.Scheme)scheme, (Space)space, (String)fsName));
        return uri;
    }
}

