/*
 * Decompiled with CFR 0.152.
 */
package org.lesscss.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lesscss.logging.LessLogger;
import org.lesscss.logging.LessLoggerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JULILessLoggerProvider
implements LessLoggerProvider {
    JULILessLoggerProvider() {
    }

    @Override
    public LessLogger getLogger(Class<?> clazz) {
        return new JULILessLogger(Logger.getLogger(clazz.getName()));
    }

    private static class JULILessLogger
    implements LessLogger {
        private final Logger logger;

        private JULILessLogger(Logger logger) {
            this.logger = logger;
        }

        public boolean isDebugEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        public void debug(String msg) {
            this.logger.fine(msg);
        }

        public void debug(String format, Object ... args) {
            if (this.isDebugEnabled()) {
                this.logger.fine(String.format(format, args));
            }
        }

        public void info(String msg) {
            this.logger.info(msg);
        }

        public void info(String format, Object ... args) {
            if (this.isInfoEnabled()) {
                this.logger.info(String.format(format, args));
            }
        }

        public void error(String msg, Throwable t) {
            this.logger.log(Level.SEVERE, msg, t);
        }

        public void error(String format, Object ... args) {
            this.logger.severe(String.format(format, args));
        }
    }
}

