/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.client.exporter;

import javax.enterprise.context.ApplicationScoped;

import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class PlaceManagerJSExporter implements UberfireJSExporter {

    public static void goTo(final String place) {
        final SyncBeanManager beanManager = IOC.getBeanManager();
        final PlaceManager placeManager = beanManager.lookupBean(PlaceManager.class).getInstance();
        placeManager.goTo(new DefaultPlaceRequest(place));
    }

    public static void goTo(final String place,
                            final HTMLElement element) {
        final SyncBeanManager beanManager = IOC.getBeanManager();
        final PlaceManager placeManager = beanManager.lookupBean(PlaceManager.class).getInstance();
        placeManager.goTo(place, element);
    }

    @Override
    public void export() {
        publish();
    }

    private native void publish() /*-{
        $wnd.$goToPlace = @org.uberfire.client.exporter.PlaceManagerJSExporter::goTo(Ljava/lang/String;);
        $wnd.$goToScreen = @org.uberfire.client.exporter.PlaceManagerJSExporter::goTo(Ljava/lang/String;Lorg/jboss/errai/common/client/dom/HTMLElement;);
    }-*/;
}
