/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.repositories;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.appformer.maven.integration.Aether;
import org.appformer.maven.integration.embedder.MavenEmbedder;
import org.appformer.maven.integration.embedder.MavenEmbedderException;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionManagementArtifactRepository
implements ArtifactRepository {
    private String name;
    private Logger logger = LoggerFactory.getLogger(DistributionManagementArtifactRepository.class);

    public DistributionManagementArtifactRepository() {
    }

    public DistributionManagementArtifactRepository(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRootDir() {
        return null;
    }

    @Override
    public Collection<File> listFiles(List<String> wildcards) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Collection<Artifact> listArtifacts(List<String> wildcards) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean containsArtifact(GAV gav) {
        return false;
    }

    @Override
    public File getArtifactFileFromRepository(GAV gav) {
        return null;
    }

    @Override
    public boolean isRepository() {
        return true;
    }

    @Override
    public boolean isPomRepository() {
        return false;
    }

    @Override
    public void deploy(String pom, Artifact ... artifacts) {
        try {
            MavenEmbedder embedder = MavenProjectLoader.newMavenEmbedder((boolean)false);
            DistributionManagement distributionManagement = this.getDistributionManagement(pom, embedder);
            if (distributionManagement != null) {
                boolean isSnapshot = Arrays.stream(artifacts).anyMatch(artifact -> artifact.isSnapshot());
                DeploymentRepository remoteRepository = null;
                if (isSnapshot) {
                    remoteRepository = distributionManagement.getSnapshotRepository();
                    if (remoteRepository == null) {
                        remoteRepository = distributionManagement.getRepository();
                    }
                } else {
                    remoteRepository = distributionManagement.getRepository();
                }
                if (remoteRepository != null) {
                    DeployRequest remoteRequest = new DeployRequest();
                    for (Artifact artifact2 : artifacts) {
                        remoteRequest.addArtifact(artifact2);
                    }
                    remoteRequest.setRepository(this.getRemoteRepoFromDeployment(remoteRepository, embedder));
                    Aether.getAether().getSystem().deploy(Aether.getAether().getSession(), remoteRequest);
                }
            }
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    private DistributionManagement getDistributionManagement(String pomXML, MavenEmbedder embedder) {
        ByteArrayInputStream is = new ByteArrayInputStream(pomXML.getBytes(Charset.forName("UTF-8")));
        MavenProject project = null;
        try {
            project = embedder.readProject((InputStream)is);
        }
        catch (ProjectBuildingException e) {
            this.logger.error("Unable to build Maven project from POM", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (MavenEmbedderException e) {
            this.logger.error("Unable to build Maven project from POM", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
        return project.getDistributionManagement();
    }

    private RemoteRepository getRemoteRepoFromDeployment(DeploymentRepository repo, MavenEmbedder embedder) {
        RemoteRepository.Builder remoteRepoBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl()).setSnapshotPolicy(new RepositoryPolicy(true, "daily", "warn")).setReleasePolicy(new RepositoryPolicy(true, "always", "warn"));
        Settings settings = MavenSettings.getSettings();
        Server server = settings.getServer(repo.getId());
        if (server != null) {
            Authentication authentication = embedder.getMavenSession().getRepositorySession().getAuthenticationSelector().getAuthentication(remoteRepoBuilder.build());
            remoteRepoBuilder.setAuthentication(authentication);
        }
        return remoteRepoBuilder.build();
    }

    @Override
    public void delete(GAV gav) {
    }
}

