/*
 * Decompiled with CFR 0.152.
 */
package org.kie.guvnor.m2repo.backend.server;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.kie.builder.GAV;

@ApplicationScoped
public class M2Repository {
    public static final String M2_REPO_ROOT = ".";
    public static final String SYSTEM_FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String REPO_ID_SNAPSHOTS = "snapshots";
    public static final String REPO_ID_RELEASES = "releases";
    private static final int BUFFER_SIZE = 1024;

    @PostConstruct
    protected void init() {
        this.setM2Repos();
    }

    private void setM2Repos() {
        File releasesRepository;
        File snapshotsRepository = new File(this.getM2RepositoryRootDir() + REPO_ID_SNAPSHOTS);
        if (!snapshotsRepository.exists()) {
            snapshotsRepository.mkdirs();
        }
        if (!(releasesRepository = new File(this.getM2RepositoryRootDir() + REPO_ID_RELEASES)).exists()) {
            releasesRepository.mkdirs();
        }
    }

    protected String getM2RepositoryRootDir() {
        return M2_REPO_ROOT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(InputStream is, GAV gav) {
        OutputStream outStream = null;
        try {
            String classifier = null;
            String fullPathToLocalFile = this.toURL(this.getM2RepositoryRootDir() + REPO_ID_RELEASES, gav, classifier);
            File file = new File(fullPathToLocalFile);
            if (!file.exists()) {
                file.createNewFile();
            }
            outStream = new BufferedOutputStream(new FileOutputStream(fullPathToLocalFile));
            byte[] buf = new byte[1024];
            int byteRead = 0;
            while ((byteRead = is.read(buf)) != -1) {
                outStream.write(buf, 0, byteRead);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void listFiles() {
    }

    protected String toURL(String repository, GAV gav, String classifier) {
        StringBuilder sb = new StringBuilder(repository);
        if (!repository.endsWith("/")) {
            sb.append("/");
        }
        return sb.append(gav.getGroupId().replace(M2_REPO_ROOT, "/")).append('/').append(gav.getArtifactId()).append('/').append(gav.getVersion()).append('/').append(this.toFileName(gav, classifier)).toString();
    }

    protected String toFileName(GAV gav, String classifier) {
        if (classifier != null) {
            return gav.getArtifactId() + "-" + gav.getVersion() + "-" + classifier + M2_REPO_ROOT + this.getFileExtension();
        }
        return gav.getArtifactId() + "-" + gav.getVersion() + M2_REPO_ROOT + this.getFileExtension();
    }

    private String getFileExtension() {
        String type = "jar";
        if (type.equalsIgnoreCase("ear")) {
            return "ear";
        }
        if (type.equalsIgnoreCase("pom")) {
            return "pom";
        }
        if (type.equalsIgnoreCase("war")) {
            return "war";
        }
        return "jar";
    }
}

