/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.structure.backend.repositories.git.hooks;

import org.guvnor.structure.repositories.impl.git.GitRepository;

/**
 * Triggers the notification for the post-commit git hook
 */
public interface PostCommitNotificationService {

    String BUNDLE_PARAM = "appformer.git.hooks.bundle";

    /**
     * Triggers the notification for a given repo & exitCode
     * @param repo The {@link GitRepository} that triggered the post-commit git hook
     * @param exitCode The exit code of the post-commit script
     */
    void notifyUser(GitRepository repo, Integer exitCode);
}
