"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var closest_file_data_1 = require("closest-file-data");
var fs_1 = require("fs");
var constants_1 = require("./constants");
var babelReaders = [
    {
        basename: constants_1.BABELRC_FILENAME,
        read: function (f) { return JSON.parse(fs_1.readFileSync(f, 'utf8')); },
    },
    { basename: constants_1.BABELRC_JS_FILENAME, read: function (f) { return require(f); } },
    { basename: constants_1.PACKAGE_JSON, read: function (f) { return require(f)[constants_1.BABEL_CONFIG_KEY]; } },
];
function getBabelRC(filename) {
    var res = closest_file_data_1.default(filename, babelReaders);
    return res && res.data;
}
exports.default = getBabelRC;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0LWJhYmVsLXJjLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3V0aWxzL2dldC1iYWJlbC1yYy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHVEQUFnRDtBQUNoRCx5QkFBa0M7QUFDbEMseUNBS3FCO0FBRXJCLElBQU0sWUFBWSxHQUFHO0lBQ25CO1FBQ0UsUUFBUSxFQUFFLDRCQUFnQjtRQUMxQixJQUFJLEVBQUUsVUFBQSxDQUFDLElBQUksT0FBQSxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFZLENBQUMsQ0FBQyxFQUFFLE1BQU0sQ0FBQyxDQUFDLEVBQW5DLENBQW1DO0tBQy9DO0lBQ0QsRUFBRSxRQUFRLEVBQUUsK0JBQW1CLEVBQUUsSUFBSSxFQUFFLFVBQUEsQ0FBQyxJQUFJLE9BQUEsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFWLENBQVUsRUFBRTtJQUN4RCxFQUFFLFFBQVEsRUFBRSx3QkFBWSxFQUFFLElBQUksRUFBRSxVQUFBLENBQUMsSUFBSSxPQUFBLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyw0QkFBZ0IsQ0FBQyxFQUE1QixDQUE0QixFQUFFO0NBQ3BFLENBQUM7QUFFRixvQkFBbUMsUUFBUTtJQUN6QyxJQUFNLEdBQUcsR0FBRywyQkFBZSxDQUFDLFFBQVEsRUFBRSxZQUFZLENBQUMsQ0FBQztJQUNwRCxPQUFPLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDO0FBQ3pCLENBQUM7QUFIRCw2QkFHQyJ9