"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var format_diagnostics_1 = require("./format-diagnostics");
var typescript_1 = require("typescript");
function runTsDiagnostics(filePath, compilerOptions) {
    var program = typescript_1.createProgram([filePath], compilerOptions);
    var allDiagnostics = typescript_1.getPreEmitDiagnostics(program);
    if (allDiagnostics.length) {
        throw new Error(format_diagnostics_1.default(allDiagnostics));
    }
}
exports.default = runTsDiagnostics;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicnVuLXRzLWRpYWdub3N0aWNzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3V0aWxzL3J1bi10cy1kaWFnbm9zdGljcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLDJEQUF1RDtBQUN2RCx5Q0FJb0I7QUFFcEIsMEJBQ0UsUUFBZ0IsRUFDaEIsZUFBZ0M7SUFFaEMsSUFBTSxPQUFPLEdBQUcsMEJBQWEsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxFQUFFLGVBQWUsQ0FBQyxDQUFDO0lBQzNELElBQU0sY0FBYyxHQUFHLGtDQUFxQixDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBRXRELElBQUksY0FBYyxDQUFDLE1BQU0sRUFBRTtRQUN6QixNQUFNLElBQUksS0FBSyxDQUFDLDRCQUFtQixDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7S0FDdEQ7QUFDSCxDQUFDO0FBVkQsbUNBVUMifQ==