/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dashbuilder.shared.model;

import java.util.Collection;

/**
 * Dashbuilder Runtime information.
 *
 */
public class DashbuilderRuntimeInfo {

    private String mode;
    private Collection<String> availableModels;
    private boolean acceptingNewImports;

    public DashbuilderRuntimeInfo(String mode,
                                  Collection<String> availableModels,
                                  boolean acceptingNewImports) {
        this.mode = mode;
        this.availableModels = availableModels;
        this.acceptingNewImports = acceptingNewImports;
    }

    public String getMode() {
        return mode;
    }

    public Collection<String> getAvailableModels() {
        return availableModels;
    }

    public boolean isAcceptingNewImports() {
        return acceptingNewImports;
    }

}