/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dashbuilder.renderer.c3.client.charts.map.geojson.impl;

import org.dashbuilder.renderer.c3.client.charts.map.geojson.GeoJsonLoader;
import org.dashbuilder.renderer.c3.client.exports.NativeLibraryResources;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.FeatureCollection;

import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;

import jsinterop.base.Js;

public class GWTGeoJsonLoader implements GeoJsonLoader {

    @Override
    public FeatureCollection load() {
        String geoJsonStr = NativeLibraryResources.INSTANCE.countriesgeojson().getText();
        JSONValue geoJsonObject = JSONParser.parseStrict(geoJsonStr);
        return Js.cast(geoJsonObject.isObject().getJavaScriptObject());
    }

}