/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dashbuilder.dsl.factory.page;

import org.uberfire.ext.layout.editor.api.css.CssProperty;

public abstract class AbstractLayoutBuilder<T> {

    @SuppressWarnings("unchecked")
    public T property(String key, String value) {
        this.addProperty(key, value);
        return (T) this;
    }
    
    @SuppressWarnings("unchecked")
    public T cssProperty(CssProperty property, String value) {
        this.addProperty(property.getName(), value);
        return (T) this;
    }

    protected abstract void addProperty(String key, String value);

}