/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.properties;

import java.util.Properties;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.security.management.wildfly.properties.PropertiesLineWriterPredicate;

@RunWith(value=MockitoJUnitRunner.class)
public class PropertiesLineWriterPredicateTest {
    @Mock
    private Function<String, String> keyParser;
    private final Properties properties = new Properties();
    private PropertiesLineWriterPredicate tested;

    @Before
    public void setup() throws Exception {
        this.properties.put("user1", "value1");
        this.properties.put("user2", "value2");
        this.properties.put("user3", "value3");
        ((Function)Mockito.doAnswer(invocationOnMock -> (String)invocationOnMock.getArguments()[0]).when(this.keyParser)).apply(Matchers.anyString());
    }

    @Test
    public void testDeleteEntry() {
        PropertiesLineWriterPredicate predicate = this.build(false).begin(this.properties);
        Assert.assertTrue((boolean)predicate.test("user1=user1"));
        Assert.assertTrue((boolean)predicate.test("user2=user2"));
        Assert.assertTrue((boolean)predicate.test("user3=user3"));
        Assert.assertTrue((boolean)predicate.test("user4="));
        Assert.assertFalse((boolean)predicate.test("user4=value4"));
        predicate.end();
    }

    @Test
    public void testDeleteEmptyValueEntry() {
        PropertiesLineWriterPredicate predicate = this.build(true).begin(this.properties);
        Assert.assertTrue((boolean)predicate.test("user1=user1"));
        Assert.assertTrue((boolean)predicate.test("user2=user2"));
        Assert.assertTrue((boolean)predicate.test("user3=user3"));
        this.properties.put("user4", "");
        Assert.assertTrue((boolean)predicate.test("user4="));
        this.properties.put("user4", "value4");
        Assert.assertTrue((boolean)predicate.test("user4=value4"));
        Assert.assertFalse((boolean)predicate.test("user4="));
        predicate.end();
    }

    private PropertiesLineWriterPredicate build(boolean allowEmptyEntryValue) {
        this.tested = new PropertiesLineWriterPredicate(this.keyParser, allowEmptyEntryValue);
        return this.tested;
    }
}

