/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.widgets.timeline.regular.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ext.uberfire.social.activities.client.widgets.timeline.regular.model.RecentUpdatesModel;
import org.ext.uberfire.social.activities.client.widgets.timeline.regular.model.UpdateItem;
import org.ext.uberfire.social.activities.model.DefaultTypes;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.model.SocialEventType;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.junit.Assert;
import org.junit.Test;

public class RecentUpdatesModelTest {
    @Test
    public void simpleModelGeneration() {
        ArrayList<SocialActivitiesEvent> events = new ArrayList<SocialActivitiesEvent>();
        SocialUser user = new SocialUser("user");
        events.add(new SocialActivitiesEvent(user, (SocialEventType)DefaultTypes.DUMMY_EVENT, this.createDate(1, 1)).withLink("alias1", "file1"));
        events.add(new SocialActivitiesEvent(user, (SocialEventType)DefaultTypes.DUMMY_EVENT, this.createDate(1, 2)).withLink("alias2", "file2"));
        events.add(new SocialActivitiesEvent(user, (SocialEventType)DefaultTypes.DUMMY_EVENT, this.createDate(1, 3)).withLink("alias3", "file3"));
        RecentUpdatesModel model = RecentUpdatesModel.generate(events);
        Map updateItems = model.getUpdateItems();
        Set keys = updateItems.keySet();
        Iterator iterator = keys.iterator();
        Assert.assertEquals((Object)"alias3", iterator.next());
        Assert.assertEquals((Object)"alias2", iterator.next());
        Assert.assertEquals((Object)"alias1", iterator.next());
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void modelGenerationWithMoreChanges() {
        ArrayList<SocialActivitiesEvent> events = new ArrayList<SocialActivitiesEvent>();
        SocialUser user = new SocialUser("user");
        events.add(new SocialActivitiesEvent(user, (SocialEventType)DefaultTypes.DUMMY_EVENT, this.createDate(1, 1)).withLink("alias1", "file1"));
        events.add(new SocialActivitiesEvent(user, (SocialEventType)DefaultTypes.DUMMY_EVENT, this.createDate(1, 2)).withLink("alias2", "file2"));
        events.add(new SocialActivitiesEvent(user, (SocialEventType)DefaultTypes.DUMMY_EVENT, this.createDate(1, 3)).withLink("alias3", "file3"));
        events.add(new SocialActivitiesEvent(user, (SocialEventType)DefaultTypes.DUMMY_EVENT, this.createDate(1, 4)).withLink("alias1", "file1"));
        RecentUpdatesModel model = RecentUpdatesModel.generate(events);
        Map updateItems = model.getUpdateItems();
        Set keys = updateItems.keySet();
        Iterator iterator = keys.iterator();
        Assert.assertEquals((Object)"alias1", iterator.next());
        List items = model.getUpdateItems("alias1");
        Assert.assertTrue((items.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"alias1", (Object)((UpdateItem)items.get(0)).getEvent().getLinkLabel());
        Assert.assertEquals((Object)"alias1", (Object)((UpdateItem)items.get(1)).getEvent().getLinkLabel());
        Assert.assertEquals((Object)"alias3", iterator.next());
        Assert.assertEquals((Object)"alias2", iterator.next());
        Assert.assertTrue((boolean)true);
    }

    private Date createDate(int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(0L);
        cal.set(2014, 6, 1, 1, minute, second);
        Date date = cal.getTime();
        return date;
    }
}

