/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.widgets.item;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import org.ext.uberfire.social.activities.client.user.SocialUserImageProvider;
import org.ext.uberfire.social.activities.client.widgets.item.bundle.SocialBundleHelper;
import org.ext.uberfire.social.activities.client.widgets.item.model.LinkCommandParams;
import org.ext.uberfire.social.activities.client.widgets.item.model.SimpleItemWidgetModel;
import org.ext.uberfire.social.activities.client.widgets.utils.SocialDateFormatter;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.service.SocialUserImageRepositoryAPI;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.ImageAnchor;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jboss.errai.ioc.client.container.IOC;
import org.uberfire.client.resources.UberfireResources;
import org.uberfire.client.workbench.type.ClientResourceType;

public class SimpleItemWidget
extends Composite {
    private static final Image GENERIC_FILE_IMAGE = new Image(UberfireResources.INSTANCE.images().typeGenericFile());
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    FlowPanel left;
    @UiField
    Heading heading;
    @UiField
    Paragraph desc;
    private SocialUserImageProvider imageProvider = (SocialUserImageProvider)IOC.getBeanManager().lookupBean(SocialUserImageProvider.class, new Annotation[0]).getInstance();

    public void init(SimpleItemWidgetModel model) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        if (!model.shouldIPrintIcon()) {
            this.createThumbNail(model.getSocialUser());
        } else {
            this.createIcon(model);
        }
        this.createDescriptionContent(model);
        this.createHeadingContent(model);
    }

    private void createHeadingContent(SimpleItemWidgetModel model) {
        this.heading.setText(model.getSocialUser().getName());
    }

    private void createDescriptionContent(SimpleItemWidgetModel model) {
        if (model.getLinkText() != null) {
            this.desc.add(this.createLink(model));
            this.desc.add(this.createText(model));
        } else {
            this.desc.setText(model.getDescription());
        }
    }

    private Widget createText(SimpleItemWidgetModel model) {
        StringBuilder sb = new StringBuilder(" ");
        sb.append(SocialBundleHelper.getItemDescription(model.getItemDescription()));
        sb.append(" ");
        sb.append(SocialDateFormatter.format(model.getTimestamp()));
        return new Text(sb.toString());
    }

    private void createIcon(SimpleItemWidgetModel model) {
        if (model.isVFSLink()) {
            for (ClientResourceType type : model.getResourceTypes()) {
                if (!type.accept(model.getLinkPath())) continue;
                this.addIconImage((Image)type.getIcon());
                break;
            }
        } else {
            Image maybeAlreadyAttachedImage = GENERIC_FILE_IMAGE;
            this.addIconImage(maybeAlreadyAttachedImage);
        }
    }

    private void addIconImage(Image image) {
        ImageAnchor newImage = new ImageAnchor();
        newImage.setUrl(image.getUrl());
        newImage.setPull(Pull.LEFT);
        newImage.setAsMediaObject(true);
        this.left.add((Widget)newImage);
    }

    private Widget createLink(final SimpleItemWidgetModel model) {
        Anchor link = new Anchor();
        link.setText(model.getLinkText());
        link.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                model.getLinkCommand().execute((Object)new LinkCommandParams(model.getEventType(), model.getLinkURI(), model.getLinkType()).withLinkParams(model.getLinkParams()));
            }
        });
        return link;
    }

    private void createThumbNail(SocialUser socialUser) {
        Image userImage = this.imageProvider.getImageForSocialUser(socialUser, SocialUserImageRepositoryAPI.ImageSize.SMALL);
        this.addIconImage(userImage);
    }

    static interface MyUiBinder
    extends UiBinder<Widget, SimpleItemWidget> {
    }
}

