/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.widgets.timeline.regular;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import org.ext.uberfire.social.activities.client.resources.i18n.Constants;
import org.ext.uberfire.social.activities.client.widgets.item.SimpleItemWidget;
import org.ext.uberfire.social.activities.client.widgets.item.SocialItemExpandedWidget;
import org.ext.uberfire.social.activities.client.widgets.item.bundle.SocialBundleHelper;
import org.ext.uberfire.social.activities.client.widgets.item.model.SimpleItemWidgetModel;
import org.ext.uberfire.social.activities.client.widgets.item.model.SocialItemExpandedWidgetModel;
import org.ext.uberfire.social.activities.client.widgets.timeline.regular.model.RecentUpdatesModel;
import org.ext.uberfire.social.activities.client.widgets.timeline.regular.model.SocialTimelineWidgetModel;
import org.ext.uberfire.social.activities.client.widgets.timeline.regular.model.UpdateItem;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.service.SocialTimeLineRepositoryAPI;
import org.ext.uberfire.social.activities.service.SocialTimelineRulesQueryAPI;
import org.gwtbootstrap3.client.ui.MediaList;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;

public class SocialTimelineWidget
extends Composite {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    MediaList itemsPanel;
    private SocialTimelineWidgetModel model;

    public void init(SocialTimelineWidgetModel model) {
        this.model = model;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        if (model.isDroolsQuery()) {
            this.createDroolsQuerySocialItemsWidget(model);
        } else {
            this.createRegularQuerySocialItemsWidget(model);
        }
    }

    private void createRegularQuerySocialItemsWidget(final SocialTimelineWidgetModel model) {
        ((SocialTimeLineRepositoryAPI)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<List<SocialActivitiesEvent>>(){

            public void callback(List<SocialActivitiesEvent> events) {
                if (events.isEmpty()) {
                    SocialTimelineWidget.this.displayNoEvents();
                } else {
                    SocialTimelineWidget.this.createEventsWidget(events, model);
                }
            }
        }, SocialTimeLineRepositoryAPI.class)).getLastEventTimeline(model.getSocialEventType().name());
    }

    private void createEventsWidget(List<SocialActivitiesEvent> events, SocialTimelineWidgetModel model) {
        for (SocialActivitiesEvent event : events) {
            if (event.hasLink()) {
                this.createSimpleWidgetWithLink(event);
                continue;
            }
            this.createSimpleWidget(event);
        }
    }

    private void createSimpleWidgetWithLink(SocialActivitiesEvent event) {
        final SimpleItemWidgetModel itemModel = new SimpleItemWidgetModel(this.model, event.getType(), event.getTimestamp(), event.getLinkLabel(), event.getLinkTarget(), event.getLinkType(), event.getDescription(), SocialBundleHelper.getItemDescription(event.getAdicionalInfos()), this.model.getSocialUser()).withLinkCommand(this.model.getLinkCommand()).withLinkParams(event.getLinkParams());
        if (event.isVFSLink()) {
            ((VFSService)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<Path>(){

                public void callback(Path path) {
                    itemModel.withLinkPath(path);
                    SocialTimelineWidget.this.addItemWidget(itemModel);
                }
            }, VFSService.class)).get(event.getLinkTarget());
        } else {
            this.addItemWidget(itemModel);
        }
    }

    private void createSimpleWidget(SocialActivitiesEvent event) {
        SimpleItemWidgetModel rowModel = new SimpleItemWidgetModel(this.model, event.getType(), event.getTimestamp(), event.getDescription(), SocialBundleHelper.getItemDescription(event.getAdicionalInfos())).withLinkParams(event.getLinkParams());
        this.addItemWidget(rowModel);
    }

    private void addItemWidget(SimpleItemWidgetModel model) {
        SimpleItemWidget simple = (SimpleItemWidget)((Object)GWT.create(SimpleItemWidget.class));
        simple.init(model);
        this.itemsPanel.add((Widget)simple);
    }

    private void createDroolsQuerySocialItemsWidget(final SocialTimelineWidgetModel model) {
        ((SocialTimelineRulesQueryAPI)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<List<SocialActivitiesEvent>>(){

            public void callback(List<SocialActivitiesEvent> events) {
                RecentUpdatesModel recentUpdatesModel = RecentUpdatesModel.generate(events);
                Map<String, List<UpdateItem>> updateItems = recentUpdatesModel.getUpdateItems();
                if (updateItems.keySet().isEmpty()) {
                    SocialTimelineWidget.this.displayNoEvents();
                } else {
                    SocialTimelineWidget.this.createExpandedItemsWidget(recentUpdatesModel, updateItems, model);
                }
            }
        }, SocialTimelineRulesQueryAPI.class)).executeSpecificRule(model.getGlobals(), model.getDrlName(), model.getMaxResults());
    }

    private void createExpandedItemsWidget(RecentUpdatesModel recentUpdatesModel, Map<String, List<UpdateItem>> updateItems, SocialTimelineWidgetModel model) {
        for (String fileName : updateItems.keySet()) {
            SocialItemExpandedWidget widget = (SocialItemExpandedWidget)((Object)GWT.create(SocialItemExpandedWidget.class));
            widget.init(new SocialItemExpandedWidgetModel(fileName, recentUpdatesModel.getUpdateItems(fileName), model));
            this.itemsPanel.add((Widget)widget);
        }
    }

    private void displayNoEvents() {
        this.itemsPanel.add((Widget)new Paragraph(Constants.INSTANCE.NoSocialEvents()));
    }

    static interface MyUiBinder
    extends UiBinder<Widget, SocialTimelineWidget> {
    }
}

