/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.widgets.timeline.simple.model;

import java.util.List;
import org.ext.uberfire.social.activities.client.widgets.item.model.LinkCommandParams;
import org.ext.uberfire.social.activities.client.widgets.pagination.Next;
import org.ext.uberfire.social.activities.client.widgets.pagination.Previous;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.model.SocialEventType;
import org.ext.uberfire.social.activities.model.SocialPaged;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.service.SocialPredicate;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.mvp.ParameterizedCommand;

public class SimpleSocialTimelineWidgetModel {
    private SocialEventType socialEventType;
    private SocialUser socialUser;
    private SocialPredicate<SocialActivitiesEvent> predicate;
    private PlaceManager placeManager;
    private SocialPaged socialPaged;
    private Previous less;
    private Next more;
    private List<ClientResourceType> resourceTypes;
    private ParameterizedCommand<LinkCommandParams> linkCommand;

    public SimpleSocialTimelineWidgetModel(SocialEventType socialEventType, SocialPredicate<SocialActivitiesEvent> predicate, PlaceManager placeManager, SocialPaged socialPaged) {
        this.socialEventType = socialEventType;
        this.predicate = predicate;
        this.placeManager = placeManager;
        this.socialPaged = socialPaged;
    }

    public SimpleSocialTimelineWidgetModel(SocialUser socialUser, SocialPredicate<SocialActivitiesEvent> predicate, PlaceManager placeManager, SocialPaged socialPaged) {
        this.socialUser = socialUser;
        this.predicate = predicate;
        this.placeManager = placeManager;
        this.socialPaged = socialPaged;
    }

    public SimpleSocialTimelineWidgetModel withPagination(Previous less, Next more) {
        this.less = less;
        this.more = more;
        return this;
    }

    public SimpleSocialTimelineWidgetModel withLinkCommand(ParameterizedCommand<LinkCommandParams> linkCommand) {
        this.linkCommand = linkCommand;
        return this;
    }

    public SimpleSocialTimelineWidgetModel withIcons(List<ClientResourceType> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    public SimpleSocialTimelineWidgetModel withOnlyMorePagination(Next more) {
        this.more = more;
        return this;
    }

    public boolean isSocialTypeWidget() {
        return this.socialUser == null;
    }

    public SocialUser getSocialUser() {
        return this.socialUser;
    }

    public SocialPredicate<SocialActivitiesEvent> getPredicate() {
        return this.predicate;
    }

    public PlaceManager getPlaceManager() {
        return this.placeManager;
    }

    public SocialPaged getSocialPaged() {
        return this.socialPaged;
    }

    public SocialEventType getSocialEventType() {
        return this.socialEventType;
    }

    public Previous getLess() {
        return this.less;
    }

    public Next getMore() {
        return this.more;
    }

    public void updateSocialPaged(SocialPaged socialPaged) {
        this.socialPaged = socialPaged;
    }

    public List<ClientResourceType> getResourceTypes() {
        return this.resourceTypes;
    }

    public ParameterizedCommand<LinkCommandParams> getLinkCommand() {
        if (this.linkCommand == null) {
            return new ParameterizedCommand<LinkCommandParams>(){

                public void execute(LinkCommandParams parameters) {
                }
            };
        }
        return this.linkCommand;
    }
}

