/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin.utils;

import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;

public class DependencyModel {
    private final HashMap<String, Dependency> dependencyMap = new HashMap();

    public DependencyModel(Model model) {
        for (Dependency dependency : model.getDependencies()) {
            this.dependencyMap.put(DependencyModel.key(dependency), dependency);
        }
        if (model.getDependencyManagement() != null) {
            for (Dependency dependency : model.getDependencyManagement().getDependencies()) {
                this.dependencyMap.put(DependencyModel.key(dependency), dependency);
            }
        }
    }

    public Optional<Dependency> getDependency(String groupId, String artifactId, String type, String classifier) {
        Dependency dependency = this.dependencyMap.get(DependencyModel.key(groupId, artifactId, type, classifier));
        return dependency == null ? Optional.empty() : Optional.of(dependency);
    }

    private static String key(String g, String a, String t, String c) {
        Objects.requireNonNull(g);
        Objects.requireNonNull(a);
        return g + ":" + a + ":" + DependencyModel.emptyStringIfNull(t) + ":" + DependencyModel.emptyStringIfNull(c);
    }

    private static String key(Dependency d) {
        return DependencyModel.key(d.getGroupId(), d.getArtifactId(), d.getType(), d.getClassifier());
    }

    private static String emptyStringIfNull(String s) {
        return s == null ? "" : s;
    }
}

