/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.io.PomIO;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channelplugin.ChannelPluginLogger;
import org.wildfly.channelplugin.manipulation.PomManipulator;
import org.wildfly.channeltools.util.ConversionUtils;
import org.wildfly.channeltools.util.VersionUtils;

@Mojo(name="upgrade", requiresProject=true, requiresDirectInvocation=true)
public class UpgradeComponentsMojo
extends AbstractMojo {
    private static final String LOCAL_MAVEN_REPO = System.getProperty("user.home") + "/.m2/repository";
    private static final String CHANNEL_CLASSIFIER = "channel";
    private static final String CHANNEL_EXTENSION = "yaml";
    @Parameter(required=false, property="channelFile")
    String channelFile;
    @Parameter(required=false, property="manifestFile")
    String manifestFile;
    @Parameter(required=false, property="channelGAV")
    String channelGAV;
    @Parameter(required=false, property="manifestGAV")
    String manifestGAV;
    @Parameter(required=false, property="remoteRepositories")
    List<String> remoteRepositories;
    @Parameter(property="localRepository")
    String localRepositoryPath;
    @Parameter(property="ignoreStreams", defaultValue="")
    List<String> ignoreStreams;
    @Parameter(property="ignoreModules", defaultValue="")
    List<String> ignoreModules;
    @Parameter(property="ignoreProperties", defaultValue="")
    List<String> ignoreProperties;
    @Parameter(property="ignorePropertiesPrefixedWith", defaultValue="")
    List<String> ignorePropertiesPrefixedWith;
    @Parameter(property="overrideProperties")
    List<String> overrideProperties;
    @Parameter(property="overrideDependencies")
    List<String> overrideDependencies;
    @Parameter(property="inlineVersionOnConflict", defaultValue="true")
    boolean inlineVersionOnConflict;
    @Parameter(property="injectTransitiveDependencies", defaultValue="true")
    boolean injectTransitiveDependencies;
    @Parameter(property="copyExclusionsFrom")
    String copyExclusionsFrom;
    @Inject
    DependencyGraphBuilder dependencyGraphBuilder;
    @Inject
    MavenProject mavenProject;
    @Inject
    MavenSession mavenSession;
    @Inject
    PomIO pomIO;
    @Inject
    ManipulationSession manipulationSession;
    @Inject
    RepositorySystem repositorySystem;
    private Channel channel;
    private ChannelSession channelSession;
    private final List<ProjectRef> ignoredStreams = new ArrayList<ProjectRef>();
    private final List<ProjectRef> ignoredModules = new ArrayList<ProjectRef>();
    private Set<ProjectVersionRef> projectGavs;
    private final HashMap<Pair<String, String>, PomManipulator> manipulators = new HashMap();
    private final HashMap<Pair<Project, String>, String> upgradedProperties = new HashMap();
    private final Set<ProjectRef> declaredDependencies = new HashSet<ProjectRef>();

    private void init() throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)this.localRepositoryPath)) {
            this.localRepositoryPath = LOCAL_MAVEN_REPO;
        }
        DefaultRepositorySystemSession repositorySystemSession = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(this.localRepositoryPath);
        LocalRepositoryManager localRepoManager = this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)repositorySystemSession, localRepository);
        repositorySystemSession.setLocalRepositoryManager(localRepoManager);
        this.initChannel();
        if (!this.remoteRepositories.isEmpty()) {
            this.channel = this.overrideRemoteRepositories(this.channel, this.remoteRepositories);
        }
        this.channelSession = new ChannelSession(Collections.singletonList(this.channel), (MavenVersionsResolver.Factory)new VersionResolverFactory(this.repositorySystem, (RepositorySystemSession)repositorySystemSession));
        this.ignoreStreams.forEach(ga -> this.ignoredStreams.add(SimpleProjectRef.parse((String)ga)));
        this.ignoreModules.forEach(ga -> this.ignoredModules.add(SimpleProjectRef.parse((String)ga)));
    }

    public void execute() throws MojoExecutionException {
        if (!this.mavenSession.getCurrentProject().isExecutionRoot()) {
            return;
        }
        this.init();
        try {
            List<Project> pmeProjects = this.parsePmeProjects();
            this.projectGavs = pmeProjects.stream().map(p -> new SimpleProjectVersionRef(p.getGroupId(), p.getArtifactId(), p.getVersion())).collect(Collectors.toSet());
            for (Project project : pmeProjects) {
                ProjectRef moduleGA = project.getKey().asProjectRef();
                if (this.ignoredModules.contains(moduleGA)) {
                    this.getLog().info((CharSequence)String.format("Skipping module %s:%s", project.getGroupId(), project.getArtifactId()));
                    continue;
                }
                this.getLog().info((CharSequence)String.format("Processing module %s:%s", project.getGroupId(), project.getArtifactId()));
                PomManipulator manipulator = new PomManipulator(project);
                this.manipulators.put((Pair<String, String>)Pair.of((Object)project.getGroupId(), (Object)project.getArtifactId()), manipulator);
                this.processModule(project, manipulator);
            }
            if (this.injectTransitiveDependencies) {
                this.injectTransitiveDependencies();
            }
            for (PomManipulator manipulator : this.manipulators.values()) {
                manipulator.writePom();
            }
        }
        catch (XMLStreamException | ManipulationException e) {
            throw new MojoExecutionException("Project parsing failed", (Exception)e);
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Dependency collector error", (Exception)((Object)e));
        }
    }

    private void processModule(Project pmeProject, PomManipulator manipulator) throws ManipulationException, XMLStreamException {
        Map<ArtifactRef, Dependency> resolvedProjectDependencies = this.collectResolvedProjectDependencies(pmeProject);
        resolvedProjectDependencies.keySet().forEach(a -> this.declaredDependencies.add(a.asProjectRef()));
        List<String> overriddenProperties = this.performHardPropertyOverrides(manipulator);
        List<Dependency> overriddenDependencies = this.performHardDependencyOverrides(resolvedProjectDependencies, manipulator);
        List<Pair<Dependency, String>> dependenciesToUpgrade = this.findDepenenciesToUpgrade(resolvedProjectDependencies);
        for (Pair<Dependency, String> upgrade : dependenciesToUpgrade) {
            String newVersion = (String)upgrade.getRight();
            Dependency locatedDependency = (Dependency)upgrade.getLeft();
            if (overriddenDependencies.contains(locatedDependency)) continue;
            if (VersionUtils.isProperty((String)locatedDependency.getVersion())) {
                Dependency d;
                String originalVersionString = locatedDependency.getVersion();
                String versionPropertyName = VersionUtils.extractPropertyName((String)originalVersionString);
                if (overriddenProperties.contains(versionPropertyName)) continue;
                Pair<Project, String> projectProperty = UpgradeComponentsMojo.followProperties(pmeProject, versionPropertyName);
                Project targetProject = (Project)projectProperty.getLeft();
                String targetPropertyName = (String)projectProperty.getRight();
                if (projectProperty == null) {
                    d = locatedDependency;
                    ChannelPluginLogger.LOGGER.errorf("Unable to upgrade %s:%s:%s to '%s', can't locate property '%s' in POM file %s", new Object[]{d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, versionPropertyName, pmeProject.getPom().getPath()});
                    continue;
                }
                if (this.isIgnoredProperty(targetPropertyName)) {
                    this.getLog().info((CharSequence)String.format("Ignoring property '%s' (ignored prefix)", targetPropertyName));
                    continue;
                }
                if (this.upgradedProperties.containsKey(projectProperty) && !this.upgradedProperties.get(projectProperty).equals(newVersion)) {
                    d = locatedDependency;
                    String propertyName = (String)projectProperty.getRight();
                    String currentPropertyValue = this.upgradedProperties.get(projectProperty);
                    if (this.inlineVersionOnConflict) {
                        this.getLog().warn((CharSequence)String.format("Inlining version string for %s:%s:%s, new version '%s'. The original version property '%s' has already been modified to '%s'.", d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, propertyName, currentPropertyValue));
                        manipulator.overrideDependencyVersion(d.getGroupId(), d.getArtifactId(), originalVersionString, newVersion);
                        continue;
                    }
                    this.getLog().warn((CharSequence)String.format("Can't upgrade %s:%s:%s to '%s', property '%s' was already upgraded to '%s'.", d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, propertyName, currentPropertyValue));
                    continue;
                }
                this.upgradedProperties.put(projectProperty, newVersion);
                PomManipulator targetManipulator = this.manipulators.get(Pair.of((Object)targetProject.getGroupId(), (Object)targetProject.getArtifactId()));
                targetManipulator.overrideProperty(targetPropertyName, newVersion);
                continue;
            }
            manipulator.overrideDependencyVersion(ConversionUtils.toArtifactRef((Dependency)locatedDependency), newVersion);
        }
    }

    private void injectTransitiveDependencies() throws DependencyGraphBuilderException, XMLStreamException {
        PomManipulator rootManipulator = this.manipulators.get(Pair.of((Object)this.mavenProject.getGroupId(), (Object)this.mavenProject.getArtifactId()));
        Map<ArtifactRef, Set<ProjectRef>> undeclaredDependencies = this.collectUndeclaredDependencies();
        List dependenciesToInject = undeclaredDependencies.entrySet().stream().sorted((e1, e2) -> ((ArtifactRef)e1.getKey()).compareTo((Object)((ProjectRef)e2.getKey()))).filter(entry -> {
            ArtifactRef a = (ArtifactRef)entry.getKey();
            try {
                String newVersion = this.channelSession.findLatestMavenArtifactVersion(a.getGroupId(), a.getArtifactId(), a.getType(), a.getClassifier(), a.getVersionString());
                return !newVersion.equals(a.getVersionString());
            }
            catch (UnresolvedMavenArtifactException e) {
                return false;
            }
        }).filter(entry -> {
            ArtifactRef a = (ArtifactRef)entry.getKey();
            return !this.ignoredStreams.contains(new SimpleProjectRef(a.getGroupId(), a.getArtifactId())) && !this.ignoredStreams.contains(new SimpleProjectRef(a.getGroupId(), "*"));
        }).collect(Collectors.toList());
        for (Map.Entry entry2 : dependenciesToInject) {
            ArtifactRef a = (ArtifactRef)entry2.getKey();
            try {
                String newVersion = this.channelSession.findLatestMavenArtifactVersion(a.getGroupId(), a.getArtifactId(), a.getType(), a.getClassifier(), a.getVersionString());
                if (newVersion.equals(a.getVersionString())) continue;
                SimpleArtifactRef newDependency = new SimpleArtifactRef(a.getGroupId(), a.getArtifactId(), newVersion, a.getType(), a.getClassifier());
                this.getLog().info((CharSequence)String.format("Injecting undeclared dependency: %s", newDependency));
                rootManipulator.injectManagedDependency((ArtifactRef)newDependency, (Collection)entry2.getValue());
            }
            catch (UnresolvedMavenArtifactException e) {
                this.getLog().error((CharSequence)String.format("Unable to resolve dependency %s", a));
            }
        }
    }

    private List<String> performHardPropertyOverrides(PomManipulator manipulator) throws XMLStreamException {
        ArrayList<String> overriddenProperties = new ArrayList<String>();
        for (String nameValue : this.overrideProperties) {
            String[] split = nameValue.split("=");
            if (split.length != 2) {
                this.getLog().error((CharSequence)String.format("Can't interpret property to override settings: '%s'", nameValue));
                continue;
            }
            String propertyName = split[0];
            String propertyValue = split[1];
            if (!manipulator.overrideProperty(propertyName, propertyValue)) continue;
            this.getLog().info((CharSequence)String.format("Property '%s' overridden to '%s'", propertyName, propertyValue));
            overriddenProperties.add(propertyName);
        }
        return overriddenProperties;
    }

    private List<Dependency> performHardDependencyOverrides(Map<ArtifactRef, Dependency> resolvedProjectDependencies, PomManipulator manipulator) throws XMLStreamException {
        ArrayList<Dependency> overriddenDependencies = new ArrayList<Dependency>();
        for (Dependency dependency : resolvedProjectDependencies.values()) {
            Optional<String> overridenVersion = this.findOverridenVersion(dependency);
            if (!overridenVersion.isPresent()) continue;
            manipulator.overrideDependencyVersion(ConversionUtils.toArtifactRef((Dependency)dependency), overridenVersion.get());
            overriddenDependencies.add(dependency);
        }
        return overriddenDependencies;
    }

    private Optional<String> findOverridenVersion(Dependency dependency) {
        for (String gav : this.overrideDependencies) {
            String[] split = gav.split(":");
            if (split.length != 3) continue;
            String g = split[0];
            String a = split[1];
            String v = split[2];
            if (!dependency.getGroupId().equals(g) || !dependency.getArtifactId().equals(a)) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    private boolean isIgnoredProperty(String propertyName) {
        if (this.ignoreProperties.contains(propertyName)) {
            return true;
        }
        for (String prefix : this.ignorePropertiesPrefixedWith) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private Map<ArtifactRef, Dependency> collectResolvedProjectDependencies(Project pmeProject) throws ManipulationException {
        HashMap<ArtifactRef, Dependency> projectDependencies = new HashMap<ArtifactRef, Dependency>();
        projectDependencies.putAll(pmeProject.getResolvedManagedDependencies((MavenSessionHandler)this.manipulationSession));
        projectDependencies.putAll(pmeProject.getResolvedDependencies((MavenSessionHandler)this.manipulationSession));
        if (projectDependencies.size() == 0) {
            this.getLog().debug((CharSequence)("No dependencies found in " + pmeProject.getArtifactId()));
        }
        return projectDependencies;
    }

    private List<Pair<Dependency, String>> findDepenenciesToUpgrade(Map<ArtifactRef, Dependency> resolvedProjectDependencies) {
        ArrayList<Pair<Dependency, String>> dependenciesToUpgrade = new ArrayList<Pair<Dependency, String>>();
        for (Map.Entry<ArtifactRef, Dependency> entry : resolvedProjectDependencies.entrySet()) {
            ArtifactRef artifactRef = entry.getKey();
            Dependency dependency = entry.getValue();
            Objects.requireNonNull(artifactRef);
            Objects.requireNonNull(dependency);
            if (this.projectGavs.contains(artifactRef.asProjectVersionRef())) {
                this.getLog().debug((CharSequence)("Ignoring in-project dependency: " + artifactRef.asProjectVersionRef().toString()));
                continue;
            }
            if (this.ignoredStreams.contains(artifactRef.asProjectRef())) {
                this.getLog().info((CharSequence)("Skipping dependency (ignored stream): " + artifactRef.asProjectVersionRef().toString()));
                continue;
            }
            SimpleProjectRef wildCardIgnoredProjectRef = new SimpleProjectRef(artifactRef.getGroupId(), "*");
            if (this.ignoredStreams.contains(wildCardIgnoredProjectRef)) {
                this.getLog().info((CharSequence)("Skipping dependency (ignored stream): " + artifactRef.asProjectVersionRef().toString()));
                continue;
            }
            if (artifactRef.getVersionString() == null) {
                this.getLog().warn((CharSequence)("Resolved dependency has null version: " + artifactRef));
                continue;
            }
            if (VersionUtils.isProperty((String)artifactRef.getVersionString())) {
                this.getLog().warn((CharSequence)("Resolved dependency has version with property: " + artifactRef));
                continue;
            }
            try {
                String channelVersion = this.channelSession.findLatestMavenArtifactVersion(artifactRef.getGroupId(), artifactRef.getArtifactId(), artifactRef.getType(), artifactRef.getClassifier(), artifactRef.getVersionString());
                if (!channelVersion.equals(artifactRef.getVersionString())) {
                    this.getLog().info((CharSequence)("Updating dependency " + artifactRef.getGroupId() + ":" + artifactRef.getArtifactId() + ":" + artifactRef.getVersionString() + " to version " + channelVersion));
                }
                dependenciesToUpgrade.add((Pair<Dependency, String>)Pair.of((Object)dependency, (Object)channelVersion));
            }
            catch (UnresolvedMavenArtifactException e) {
                this.getLog().debug((CharSequence)("Can't resolve artifact: " + artifactRef), (Throwable)e);
            }
        }
        return dependenciesToUpgrade;
    }

    private void initChannel() throws MojoExecutionException {
        block14: {
            int numberOfSources = 0;
            if (StringUtils.isNotBlank((CharSequence)this.channelFile)) {
                ++numberOfSources;
            }
            if (StringUtils.isNotBlank((CharSequence)this.channelGAV)) {
                ++numberOfSources;
            }
            if (StringUtils.isNotBlank((CharSequence)this.manifestFile)) {
                ++numberOfSources;
            }
            if (StringUtils.isNotBlank((CharSequence)this.manifestGAV)) {
                ++numberOfSources;
            }
            if (numberOfSources > 1) {
                throw new MojoExecutionException("Exactly one of [channelFile, channelGAV, manifestFile, manifestGAV] has to be given.");
            }
            if (!StringUtils.isNotBlank((CharSequence)this.manifestFile) && !StringUtils.isNotBlank((CharSequence)this.manifestGAV) || this.remoteRepositories.isEmpty()) {
                // empty if block
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)this.channelFile)) {
                    Path channelFilePath = Path.of(this.channelFile, new String[0]);
                    if (!channelFilePath.isAbsolute()) {
                        channelFilePath = Path.of(this.mavenSession.getExecutionRootDirectory(), new String[0]).resolve(channelFilePath);
                    }
                    this.getLog().info((CharSequence)("Reading channel file " + channelFilePath));
                    this.channel = ChannelMapper.from((URL)channelFilePath.toUri().toURL());
                    break block14;
                }
                if (StringUtils.isNotBlank((CharSequence)this.channelGAV)) {
                    this.channel = this.resolveChannel(this.channelGAV);
                    break block14;
                }
                if (StringUtils.isNotBlank((CharSequence)this.manifestFile)) {
                    URL manifestUrl = Path.of(this.manifestFile, new String[0]).toUri().toURL();
                    this.channel = new Channel("a-channel", null, null, null, new ChannelManifestCoordinate(manifestUrl), null, null);
                    break block14;
                }
                if (StringUtils.isNotBlank((CharSequence)this.manifestGAV)) {
                    ProjectVersionRef gav = SimpleProjectVersionRef.parse((String)this.manifestGAV);
                    this.channel = new Channel("a-channel", null, null, null, new ChannelManifestCoordinate(gav.getGroupId(), gav.getArtifactId(), gav.getVersionString()), null, null);
                    break block14;
                }
                throw new MojoExecutionException("No channel or manifest specified.");
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Can't parse the channel or manifest file path", (Exception)e);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Failed to resolve the channel artifact", (Exception)((Object)e));
            }
        }
    }

    private Channel resolveChannel(String gavString) throws ArtifactResolutionException, MalformedURLException {
        ProjectVersionRef gav = SimpleProjectVersionRef.parse((String)gavString);
        DefaultArtifact artifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), CHANNEL_CLASSIFIER, CHANNEL_EXTENSION, gav.getVersionString());
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((org.eclipse.aether.artifact.Artifact)artifact);
        request.setRepositories(this.mavenProject.getRemoteProjectRepositories());
        ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.mavenSession.getRepositorySession(), request);
        this.getLog().info((CharSequence)String.format("Channel file resolved from %s in repository %s", artifact, artifactResult.getRepository().getId()));
        File channelFile = artifactResult.getArtifact().getFile();
        return ChannelMapper.from((URL)channelFile.toURI().toURL());
    }

    private final Channel overrideRemoteRepositories(Channel channel, List<String> repositories) {
        return new Channel(channel.getName(), channel.getDescription(), channel.getVendor(), this.createRepositories(repositories), channel.getManifestCoordinate(), channel.getBlocklistCoordinate(), channel.getNoStreamStrategy());
    }

    private final List<Repository> createRepositories(List<String> userRepositories) {
        HashMap<Object, Repository> result = new HashMap<Object, Repository>();
        int idx = 0;
        for (String input : userRepositories) {
            Repository previous;
            Object id;
            String[] segments = input.split("::");
            if (segments.length == 1) {
                id = "repo-" + idx++;
                previous = result.put(id, new Repository((String)id, segments[0]));
            } else if (segments.length == 2) {
                id = segments[0];
                previous = result.put(id, new Repository((String)id, segments[1]));
            } else {
                throw new IllegalArgumentException("Invalid remote repository entry: " + input);
            }
            if (previous == null) continue;
            throw new IllegalArgumentException("Duplicate remote repository key: '" + (String)id + "'");
        }
        return new ArrayList<Repository>(result.values());
    }

    private List<Project> parsePmeProjects() throws ManipulationException {
        return this.pomIO.parseProject(this.mavenProject.getModel().getPomFile());
    }

    private Map<ArtifactRef, Set<ProjectRef>> collectUndeclaredDependencies() throws DependencyGraphBuilderException {
        HashMap artifactExclusions = new HashMap();
        if (this.copyExclusionsFrom != null) {
            ProjectRef exclusionsModule = SimpleProjectRef.parse((String)this.copyExclusionsFrom);
            Optional<MavenProject> exclusionsProject = this.mavenProject.getCollectedProjects().stream().filter(p -> exclusionsModule.getGroupId().equals(p.getGroupId()) && exclusionsModule.getArtifactId().equals(p.getArtifactId())).findFirst();
            if (exclusionsProject.isPresent()) {
                DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
                buildingRequest.setProject(exclusionsProject.get());
                DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
                CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
                rootNode.accept((DependencyNodeVisitor)visitor);
                visitor.getNodes().forEach(node -> {
                    HashSet exclusionSet = new HashSet(ConversionUtils.toProjectRefs((List)node.getExclusions()));
                    Set previousExclusions = artifactExclusions.put(ConversionUtils.toArtifactRef((Artifact)node.getArtifact()), exclusionSet);
                    if (previousExclusions != null) {
                        exclusionSet.addAll(previousExclusions);
                    }
                });
            }
        }
        HashMap<ArtifactRef, Set<ProjectRef>> undeclaredDependencies = new HashMap<ArtifactRef, Set<ProjectRef>>();
        for (MavenProject module : this.mavenProject.getCollectedProjects()) {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
            buildingRequest.setProject(module);
            DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
            CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
            rootNode.accept((DependencyNodeVisitor)visitor);
            visitor.getNodes().forEach(node -> {
                ArtifactRef artifact = ConversionUtils.toArtifactRef((Artifact)node.getArtifact());
                Set exclusions = (Set)artifactExclusions.get(artifact);
                if (!this.declaredDependencies.contains(artifact.asProjectRef())) {
                    if ("httpclient".equals(artifact.getArtifactId()) || "jboss-remoting".equals(artifact.getArtifactId())) {
                        this.getLog().warn((CharSequence)String.format("Found undeclared dependency %s:%s in module %s", artifact.getGroupId(), artifact.getArtifactId(), module.getArtifactId()));
                        if (exclusions != null) {
                            this.getLog().warn((CharSequence)String.format("  Exclusions:\n  %s", exclusions.stream().map(a -> a.getGroupId() + ":" + a.getArtifactId()).collect(Collectors.joining("\n  "))));
                        }
                    }
                    undeclaredDependencies.put(artifact, exclusions);
                }
            });
        }
        return undeclaredDependencies;
    }

    static Pair<Project, String> followProperties(Project pmeProject, String propertyName) {
        String newPropertyName;
        Pair<Project, String> targetProperty;
        Properties properties = pmeProject.getModel().getProperties();
        if (!properties.containsKey(propertyName)) {
            Project parentProject = pmeProject.getProjectParent();
            if (parentProject == null) {
                return null;
            }
            return UpgradeComponentsMojo.followProperties(parentProject, propertyName);
        }
        String propertyValue = (String)properties.get(propertyName);
        if (VersionUtils.isProperty((String)propertyValue) && (targetProperty = UpgradeComponentsMojo.followProperties(pmeProject, newPropertyName = VersionUtils.extractPropertyName((String)propertyValue))) != null) {
            return targetProperty;
        }
        return Pair.of((Object)pmeProject, (Object)propertyName);
    }
}

