/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client._private;

import java.io.IOException;
import java.io.InvalidClassException;
import java.net.URI;
import java.util.ServiceConfigurationError;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InterruptedNamingException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;
import org.jboss.logging.annotations.Property;
import org.wildfly.naming.client.ExhaustedDestinationsException;
import org.wildfly.naming.client.RenameAcrossNamingProvidersException;
import org.wildfly.security.auth.AuthenticationException;

@MessageLogger(projectCode="WFNAM", length=5)
public interface Messages
extends BasicLogger {
    public static final Messages log = Logger.getMessageLogger(Messages.class, "org.wildfly.naming");

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Service configuration failure loading naming providers")
    public void serviceConfigFailed(@Cause ServiceConfigurationError var1);

    @LogMessage
    @Message(id=0, value="WildFly Naming version %s")
    public void greeting(String var1);

    @Message(id=3, value="Invalid naming provider URI: %s")
    public ConfigurationException invalidProviderUri(@Cause Exception var1, Object var2);

    @Message(id=4, value="Name \"%s\" is not found")
    public NameNotFoundException nameNotFound(Name var1, @Property(name="resolvedName") Name var2);

    @Message(id=5, value="Invalid empty name")
    public InvalidNameException invalidEmptyName();

    @Message(id=6, value="Cannot modify read-only naming context")
    public NoPermissionException readOnlyContext();

    @Message(id=7, value="Invalid URL scheme name \"%s\"")
    public InvalidNameException invalidURLSchemeName(String var1);

    @Message(id=9, value="Name index %d is out of bounds")
    public IndexOutOfBoundsException nameIndexOutOfBounds(int var1);

    @Message(id=10, value="Invalid null name segment at index %d")
    public IllegalArgumentException invalidNullSegment(int var1);

    @Message(id=11, value="Missing close quote '%s' in name \"%s\"")
    public InvalidNameException missingCloseQuote(char var1, String var2);

    @Message(id=12, value="Unterminated escape sequence in name \"%s\"")
    public InvalidNameException missingEscape(String var1);

    @Message(id=14, value="Renaming from \"%s\" to \"%s\" across providers is not supported")
    public RenameAcrossNamingProvidersException renameAcrossProviders(Name var1, Name var2);

    @Message(id=15, value="Composite name segment \"%s\" does not refer to a context")
    public NotContextException notContextInCompositeName(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=16, value="Closing context \"%s\" failed")
    public void contextCloseFailed(Context var1, @Cause Throwable var2);

    @Message(id=17, value="No JBoss Remoting endpoint has been configured")
    public CommunicationException noRemotingEndpoint();

    @Message(id=18, value="Failed to connect to remote host")
    public CommunicationException connectFailed(@Cause Throwable var1);

    @Message(id=19, value="Naming operation interrupted")
    public InterruptedNamingException operationInterrupted();

    @Message(id=20, value="Remote naming operation failed")
    public CommunicationException operationFailed(@Cause Throwable var1);

    @Message(id=22, value="The server provided no compatible protocol versions")
    public CommunicationException noCompatibleVersions();

    @Message(id=23, value="Received an invalid response from the server")
    public CommunicationException invalidResponse();

    @Message(id=24, value="Naming operation not supported")
    public OperationNotSupportedException notSupported();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=25, value="org.jboss.naming.remote.client.InitialContextFactory is deprecated; new applications should use org.wildfly.naming.client.WildFlyInitialContextFactory instead")
    public void oldContextDeprecated();

    @Message(id=26, value="No provider for found for URI: %s")
    public OperationNotSupportedException noProviderForUri(String var1);

    @Message(id=29, value="Invalid leading bytes in header")
    public CommunicationException invalidHeader();

    @Message(id=31, value="Outcome not understood")
    public IOException outcomeNotUnderstood();

    @Message(id=32, value="Peer authentication failed")
    public javax.naming.AuthenticationException authenticationFailed(@Cause AuthenticationException var1);

    @Message(id=33, value="Connection sharing not supported")
    public javax.naming.AuthenticationException connectionSharingUnsupported();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=34, value="Unexpected parameter type - expected: %d  received: %d")
    public void unexpectedParameterType(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=35, value="Failed to send exception response to client")
    public void failedToSendExceptionResponse(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="Unexpected internal error")
    public void unexpectedError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=37, value="null correlationId so error not sent to client")
    public void nullCorrelationId(@Cause Throwable var1);

    @Message(id=38, value="Unrecognized messageId")
    public IOException unrecognizedMessageId();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=39, value="Unable to send header, closing channel")
    public void failedToSendHeader(@Cause IOException var1);

    @Message(id=40, value="Unsupported protocol version [ %d ]")
    public IllegalArgumentException unsupportedProtocolVersion(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=41, value="Error determining version selected by client")
    public void failedToDetermineClientVersion(@Cause Throwable var1);

    @Message(id=43, value="Unable to load callback handler class \"%s\"")
    public RuntimeException failedToLoadCallbackHandlerClass(@Cause Exception var1, String var2);

    @Message(id=44, value="Unable to instantiate callback handler instance of type  \"%s\"")
    public NamingException failedToInstantiateCallbackHandlerInstance(@Cause Exception var1, String var2);

    @Once
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=49, value="Usage of the legacy \"remote.connections\" property is deprecated; please use javax.naming.Context#PROVIDER_URL instead")
    public void deprecatedProperties();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=51, value="Provider URLs already given via standard mechanism; ignoring legacy property-based connection configuration")
    public void ignoringLegacyProperties();

    @Message(id=52, value="Invalid value given for property \"%s\": \"%s\" is not numeric")
    public ConfigurationException invalidNumericProperty(@Cause Throwable var1, String var2, String var3);

    @Message(id=53, value="Failed to synthesize a valid provider URL")
    public ConfigurationException invalidProviderGenerated(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=54, value="Ignoring duplicate destination URI \"%s\"")
    public void ignoringDuplicateDestination(URI var1);

    @Message(id=55, value="No more destinations are available to attempt the operation (%d blocklisted, %d transiently failed). See suppressed exceptions for details")
    public ExhaustedDestinationsException noMoreDestinations(int var1, int var2);

    @Message(id=56, value="No more destinations are available to attempt the operation.")
    public ExhaustedDestinationsException noMoreDestinations();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=57, value="jboss-naming-client.properties is deprecated; new applications should use org.wildfly.naming.client.WildFlyInitialContextFactory instead")
    public void oldClientPropertyFileDeprecated();

    @Message(id=58, value="Exception resolving class %s for unmarshalling; it has either been blocklisted or not allowlisted")
    public InvalidClassException cannotResolveFilteredClass(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=59, value="JavaEE to JakartaEE backward compatibility layer have been installed")
    public void javaeeToJakartaeeBackwardCompatibilityLayerInstalled();
}

