/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import io.netty.buffer.ByteBuf;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage;

public class SessionReceiveMessage_1X
extends SessionReceiveMessage {
    public SessionReceiveMessage_1X(long consumerID, ICoreMessage message, int deliveryCount) {
        super(consumerID, message, deliveryCount);
    }

    public SessionReceiveMessage_1X(CoreMessage message) {
        super(message);
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        this.message.sendBuffer_1X(buffer.byteBuf());
        buffer.writeLong(this.consumerID);
        buffer.writeInt(this.deliveryCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActiveMQBuffer encode(CoreRemotingConnection connection) {
        ICoreMessage messageSynchronize;
        ICoreMessage iCoreMessage = messageSynchronize = this.message;
        synchronized (iCoreMessage) {
            return super.encode(connection);
        }
    }

    @Override
    protected void receiveMessage(ByteBuf buffer) {
        this.message.receiveBuffer_1X(buffer);
    }

    @Override
    public int expectedEncodeSize() {
        return super.expectedEncodeSize() + 4;
    }
}

