/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import org.jboss.ejb._private.Keys;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.client.AuthenticationContext;

@ClientInterceptorPriority(value=200025)
public class AuthenticationContextEJBClientInterceptor
implements EJBClientInterceptor {
    public static final int PRIORITY = 200025;

    @Override
    public SessionID handleSessionCreation(EJBSessionCreationInvocationContext context) throws Exception {
        return this.call(context::proceed, context);
    }

    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        this.call(() -> {
            context.sendRequest();
            return null;
        }, context);
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        return this.call(context::getResult, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T call(ExceptionSupplier<T, Exception> action, AbstractInvocationContext context) throws Exception {
        AuthenticationContext captured = AuthenticationContext.captureCurrent();
        AuthenticationContext previous = context.putAttachment(Keys.AUTHENTICATION_CONTEXT_ATTACHMENT_KEY, captured);
        try {
            T t = action.get();
            return t;
        }
        finally {
            if (previous == null) {
                context.removeAttachment(Keys.AUTHENTICATION_CONTEXT_ATTACHMENT_KEY);
            } else {
                context.putAttachment(Keys.AUTHENTICATION_CONTEXT_ATTACHMENT_KEY, previous);
            }
        }
    }
}

