/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.TimeScheduler;

public class RATE_LIMITER2
extends Protocol {
    @Property(description="Max number of bytes that can be sent in the given interval", type=AttributeType.BYTES)
    protected int max_bytes = 20000000;
    @Property(description="Interval (ms) at which the bucket is replenished")
    protected long interval = 1000L;
    @Property(description="If true, messages with a DONT_BLOCK flag will be dropped instead of blocking when no bytes are left")
    protected boolean drop_dont_block_msgs;
    @ManagedAttribute
    protected long bytes_left = this.max_bytes;
    @ManagedAttribute(description="Number of replenishments")
    protected int num_replenishments;
    @ManagedAttribute(description="Number of messages dropped instead of blocking because of the DONT_BLOCK flag")
    protected final LongAdder num_dropped_msgs = new LongAdder();
    @ManagedAttribute(description="Number of times a thread was blocked trying to send a message")
    protected final LongAdder num_blockings = new LongAdder();
    @ManagedAttribute(description="Average blocking time", unit=TimeUnit.NANOSECONDS)
    protected final AverageMinMax avg_block_time = (AverageMinMax)new AverageMinMax().unit(TimeUnit.NANOSECONDS);
    protected Lock lock = new ReentrantLock(true);
    protected Condition cond = this.lock.newCondition();
    protected boolean running = true;
    protected TimeScheduler timer;
    protected Future<?> f;
    protected final Runnable task = this::replenish;

    public int maxBytes() {
        return this.max_bytes;
    }

    public RATE_LIMITER2 maxBytes(int m) {
        this.max_bytes = m;
        return this;
    }

    public long interval() {
        return this.interval;
    }

    public RATE_LIMITER2 interval(long i) {
        this.interval = i;
        return this;
    }

    public boolean dropDontBlockMessages() {
        return this.drop_dont_block_msgs;
    }

    public RATE_LIMITER2 dropDontBlockMessages(boolean p) {
        this.drop_dont_block_msgs = p;
        return this;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.bytes_left = this.max_bytes;
        this.timer = Objects.requireNonNull(this.getTransport().getTimer());
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.running = true;
        this.f = this.timer.scheduleWithFixedDelay(this.task, this.interval, this.interval, TimeUnit.MILLISECONDS, false);
    }

    @Override
    public void stop() {
        super.stop();
        this.running = false;
        this.f.cancel(false);
        this.lock.lock();
        try {
            this.bytes_left = this.max_bytes;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_replenishments = 0;
        this.num_blockings.reset();
        this.num_dropped_msgs.reset();
        this.avg_block_time.clear();
    }

    @ManagedOperation(description="Replenishes the bytes")
    public void replenish() {
        this.lock.lock();
        try {
            this.bytes_left = this.max_bytes;
            ++this.num_replenishments;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @ManagedOperation(description="Change the interval and restart the replenisher task")
    public void changeInterval(long new_interval) {
        if (new_interval <= 0L) {
            throw new IllegalArgumentException("interval cannot be <= 0");
        }
        this.interval = new_interval;
        if (this.f != null) {
            this.f.cancel(false);
        }
        if (this.timer != null) {
            this.f = this.timer.scheduleWithFixedDelay(this.task, this.interval, this.interval, TimeUnit.MILLISECONDS, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Message msg) {
        int len = msg.getLength();
        if (len == 0 || msg.isFlagSet(Message.Flag.NO_FC)) {
            return this.down_prot.down(msg);
        }
        this.lock.lock();
        try {
            if (this.bytes_left - (long)len >= 0L) {
                this.bytes_left -= (long)len;
                Object object = this.down_prot.down(msg);
                return object;
            }
            if (msg.isFlagSet(Message.TransientFlag.DONT_BLOCK) && this.drop_dont_block_msgs) {
                this.num_dropped_msgs.increment();
                Object var3_4 = null;
                return var3_4;
            }
            while (this.running && this.bytes_left - (long)len < 0L) {
                try {
                    long start = System.nanoTime();
                    this.cond.await();
                    long time = System.nanoTime() - start;
                    this.avg_block_time.add(time);
                    this.num_blockings.increment();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.down_prot.down(msg);
    }
}

