/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.discovery.AllFilterSpec;
import org.wildfly.discovery.AnyFilterSpec;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.BooleanFilterSpec;
import org.wildfly.discovery.EqualsFilterSpec;
import org.wildfly.discovery.GreaterEqualFilterSpec;
import org.wildfly.discovery.HasFilterSpec;
import org.wildfly.discovery.LessEqualFilterSpec;
import org.wildfly.discovery.NotFilterSpec;
import org.wildfly.discovery.StringIterator;
import org.wildfly.discovery.SubstringFilterSpec;

public abstract class FilterSpec
implements Serializable {
    private static final long serialVersionUID = 2473228835262926917L;
    private static final FilterSpec[] NONE = new FilterSpec[0];
    private static final FilterSpec TRUE = new BooleanFilterSpec(true);
    private static final FilterSpec FALSE = new BooleanFilterSpec(false);
    private static final int OP_EQUAL = 1;
    private static final int OP_LE = 2;
    private static final int OP_GE = 3;
    private static final int OP_APPROX = 4;

    FilterSpec() {
    }

    public abstract boolean matchesSimple(Map<String, AttributeValue> var1);

    public abstract boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> var1);

    public final boolean willMatch(Collection<String> attributeNames) {
        return !this.mayNotMatch(attributeNames);
    }

    public abstract boolean mayMatch(Collection<String> var1);

    public abstract boolean mayNotMatch(Collection<String> var1);

    public final boolean willNotMatch(Collection<String> attributeNames) {
        return !this.mayMatch(attributeNames);
    }

    public abstract <P, R, E extends Exception> R accept(Visitor<P, R, E> var1, P var2) throws E;

    public final <R, E extends Exception> R accept(Visitor<?, R, E> visitor) throws E {
        return this.accept(visitor, null);
    }

    public static FilterSpec fromString(String string) {
        Assert.checkNotNullParam("string", string);
        StringIterator i = new StringIterator(string);
        FilterSpec filterSpec = FilterSpec.parseFilter(i);
        if (i.hasNext()) {
            i.next();
            throw i.unexpectedCharacter();
        }
        return filterSpec;
    }

    private static FilterSpec parseFilter(StringIterator i) {
        switch (i.next()) {
            case 42: {
                return FilterSpec.all();
            }
            case 33: {
                if (i.next() != 42) {
                    throw i.unexpectedCharacter();
                }
                return FilterSpec.none();
            }
            case 40: {
                break;
            }
            default: {
                throw i.unexpectedCharacter();
            }
        }
        switch (i.peek()) {
            case 38: {
                return FilterSpec.parseAllFilter(i);
            }
            case 124: {
                return FilterSpec.parseAnyFilter(i);
            }
            case 33: {
                return FilterSpec.parseNotFilter(i);
            }
            case 40: 
            case 41: 
            case 42: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 92: 
            case 126: {
                i.next();
                throw i.unexpectedCharacter();
            }
        }
        return FilterSpec.parseStartsWithAttribute(i);
    }

    private static FilterSpec parseStartsWithAttribute(StringIterator i) {
        StringBuilder attr = new StringBuilder();
        block7: while (true) {
            int cp = i.next();
            switch (cp) {
                case 61: {
                    return FilterSpec.parsePlainOp(i, 1, attr.toString());
                }
                case 126: {
                    if (i.next() == 61) {
                        return FilterSpec.parsePlainOp(i, 4, attr.toString());
                    }
                    throw i.unexpectedCharacter();
                }
                case 62: {
                    if (i.next() == 61) {
                        return FilterSpec.parsePlainOp(i, 3, attr.toString());
                    }
                    throw i.unexpectedCharacter();
                }
                case 60: {
                    if (i.next() == 61) {
                        return FilterSpec.parsePlainOp(i, 2, attr.toString());
                    }
                    throw i.unexpectedCharacter();
                }
                case 92: {
                    FilterSpec.parseEscapedCodePoint(i, FilterSpec.getHexByte(i), attr);
                    continue block7;
                }
            }
            attr.appendCodePoint(cp);
        }
    }

    private static FilterSpec parsePlainOp(StringIterator i, int op, String attr) {
        StringBuilder val = new StringBuilder();
        block12: while (true) {
            int cp = i.next();
            switch (cp) {
                case 41: {
                    switch (op) {
                        case 4: {
                            return FilterSpec.approx(attr, val.toString());
                        }
                        case 1: {
                            return FilterSpec.equal(attr, val.toString());
                        }
                        case 3: {
                            return FilterSpec.greaterOrEqual(attr, val.toString());
                        }
                        case 2: {
                            return FilterSpec.lessOrEqual(attr, val.toString());
                        }
                    }
                    throw new IllegalStateException();
                }
                case 42: {
                    if (op == 1) {
                        if (val.length() == 0 && i.peek() == 41) {
                            i.next();
                            return FilterSpec.hasAttribute(attr);
                        }
                        return FilterSpec.parseSubstring(i, attr, val.toString());
                    }
                    throw i.unexpectedCharacter();
                }
                case 40: {
                    throw i.unexpectedCharacter();
                }
                case 92: {
                    int firstByte = FilterSpec.getHexByte(i);
                    if (firstByte == 255 && val.length() == 0) {
                        if (op == 1 || op == 3 || op == 2) {
                            return FilterSpec.parsePlainBytesOp(i, op, attr);
                        }
                        throw i.unexpectedCharacter();
                    }
                    FilterSpec.parseEscapedCodePoint(i, firstByte, val);
                    continue block12;
                }
            }
            val.appendCodePoint(cp);
        }
    }

    private static FilterSpec parsePlainBytesOp(StringIterator i, int op, String attr) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        block10: while (true) {
            int cp = i.next();
            switch (cp) {
                case 41: {
                    switch (op) {
                        case 1: {
                            return FilterSpec.equal(attr, os.toByteArray());
                        }
                        case 3: {
                            return FilterSpec.greaterOrEqual(attr, os.toByteArray());
                        }
                        case 2: {
                            return FilterSpec.lessOrEqual(attr, os.toByteArray());
                        }
                    }
                    throw new IllegalStateException();
                }
                case 40: 
                case 42: {
                    throw i.unexpectedCharacter();
                }
                case 92: {
                    os.write(FilterSpec.getHexByte(i));
                    continue block10;
                }
            }
            break;
        }
        throw i.unexpectedCharacter();
    }

    private static void parseEscapedCodePoint(StringIterator i, int firstByte, StringBuilder b) {
        if (firstByte <= 127) {
            b.appendCodePoint(firstByte);
            return;
        }
        if (firstByte >= 248) {
            b.appendCodePoint(65533);
            return;
        }
        if (firstByte >= 240) {
            int b2 = FilterSpec.getEscapedHexByte(i);
            if ((b2 & 0xC0) != 128) {
                b.appendCodePoint(65533);
                FilterSpec.parseEscapedCodePoint(i, b2, b);
                return;
            }
            int b3 = FilterSpec.getEscapedHexByte(i);
            if ((b3 & 0xC0) != 128) {
                b.appendCodePoint(65533);
                FilterSpec.parseEscapedCodePoint(i, b3, b);
                return;
            }
            int b4 = FilterSpec.getEscapedHexByte(i);
            if ((b4 & 0xC0) != 128) {
                b.appendCodePoint(65533);
                FilterSpec.parseEscapedCodePoint(i, b4, b);
                return;
            }
            b.appendCodePoint((firstByte & 0x1F) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F);
            return;
        }
        if (firstByte >= 224) {
            int b2 = FilterSpec.getEscapedHexByte(i);
            if ((b2 & 0xC0) != 128) {
                b.appendCodePoint(65533);
                FilterSpec.parseEscapedCodePoint(i, b2, b);
                return;
            }
            int b3 = FilterSpec.getEscapedHexByte(i);
            if ((b3 & 0xC0) != 128) {
                b.appendCodePoint(65533);
                FilterSpec.parseEscapedCodePoint(i, b3, b);
                return;
            }
            b.appendCodePoint((firstByte & 0x1F) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
            return;
        }
        if (firstByte >= 192) {
            int b2 = FilterSpec.getEscapedHexByte(i);
            if ((b2 & 0xC0) != 128) {
                b.appendCodePoint(65533);
                FilterSpec.parseEscapedCodePoint(i, b2, b);
                return;
            }
            b.appendCodePoint((firstByte & 0x1F) << 6 | b2 & 0x3F);
            return;
        }
        b.appendCodePoint(65533);
    }

    private static int getEscapedHexByte(StringIterator i) {
        if (i.next() != 92) {
            throw i.unexpectedCharacter();
        }
        return FilterSpec.getHexByte(i);
    }

    private static int getHexByte(StringIterator i) {
        int cp;
        int iv = i.next();
        if (iv >= 48 && iv <= 57) {
            cp = iv - 48;
        } else if (iv >= 65 && iv <= 70) {
            cp = iv - 65 + 10;
        } else if (iv >= 97 && iv <= 102) {
            cp = iv - 97 + 10;
        } else {
            throw i.unexpectedCharacter();
        }
        iv = i.next();
        if (iv >= 48 && iv <= 57) {
            cp = cp * 16 + iv - 48;
        } else if (iv >= 65 && iv <= 70) {
            cp = cp * 16 + iv - 65 + 10;
        } else if (iv >= 97 && iv <= 102) {
            cp = cp * 16 + iv - 97 + 10;
        } else {
            throw i.unexpectedCharacter();
        }
        return cp;
    }

    private static FilterSpec parseSubstring(StringIterator i, String attr, String initialPart) {
        StringBuilder val = new StringBuilder();
        while (true) {
            int cp = i.next();
            switch (cp) {
                case 41: {
                    return FilterSpec.substringMatch(attr, initialPart, val.toString());
                }
                case 42: {
                    throw i.unexpectedCharacter();
                }
                case 92: {
                    int iv = i.next();
                    if (iv >= 48 && iv <= 57) {
                        cp = iv - 48;
                    } else if (iv >= 65 && iv <= 70) {
                        cp = iv - 65 + 10;
                    } else if (iv >= 97 && iv <= 102) {
                        cp = iv - 97 + 10;
                    } else {
                        throw i.unexpectedCharacter();
                    }
                    iv = i.next();
                    if (iv >= 48 && iv <= 57) {
                        cp = cp * 10 + iv - 48;
                        break;
                    }
                    if (iv >= 65 && iv <= 70) {
                        cp = cp * 10 + iv - 65 + 10;
                        break;
                    }
                    if (iv >= 97 && iv <= 102) {
                        cp = cp * 10 + iv - 97 + 10;
                        break;
                    }
                    throw i.unexpectedCharacter();
                }
            }
            val.appendCodePoint(cp);
        }
    }

    private static FilterSpec parseAllFilter(StringIterator i) {
        i.next();
        ArrayList<FilterSpec> filters = new ArrayList<FilterSpec>();
        while (true) {
            if (i.peek() == 41) {
                i.next();
                if (filters.isEmpty()) {
                    return FilterSpec.all(NONE);
                }
                return FilterSpec.all(filters.toArray(new FilterSpec[filters.size()]));
            }
            filters.add(FilterSpec.parseFilter(i));
        }
    }

    private static FilterSpec parseAnyFilter(StringIterator i) {
        i.next();
        ArrayList<FilterSpec> filters = new ArrayList<FilterSpec>();
        while (true) {
            if (i.peek() == 41) {
                i.next();
                if (filters.isEmpty()) {
                    return FilterSpec.any(NONE);
                }
                return FilterSpec.any(filters.toArray(new FilterSpec[filters.size()]));
            }
            filters.add(FilterSpec.parseFilter(i));
        }
    }

    private static FilterSpec parseNotFilter(StringIterator i) {
        i.next();
        FilterSpec result = FilterSpec.not(FilterSpec.parseFilter(i));
        if (i.next() != 41) {
            throw i.unexpectedCharacter();
        }
        return result;
    }

    public static FilterSpec all() {
        return TRUE;
    }

    public static FilterSpec none() {
        return FALSE;
    }

    public static FilterSpec all(FilterSpec ... specs) {
        Assert.checkNotNullParam("specs", specs);
        return FilterSpec.all(specs, true);
    }

    public static FilterSpec all(Collection<FilterSpec> specs) {
        Assert.checkNotNullParam("specs", specs);
        return FilterSpec.all(specs.toArray(NONE), false);
    }

    private static FilterSpec all(FilterSpec[] specs, boolean clone) {
        return specs.length == 0 ? FilterSpec.all() : new AllFilterSpec(clone ? (FilterSpec[])specs.clone() : specs);
    }

    public static FilterSpec any(FilterSpec ... specs) {
        Assert.checkNotNullParam("specs", specs);
        return FilterSpec.any(specs, true);
    }

    public static FilterSpec any(Collection<FilterSpec> specs) {
        Assert.checkNotNullParam("specs", specs);
        return FilterSpec.any(specs.toArray(NONE), false);
    }

    private static FilterSpec any(FilterSpec[] specs, boolean clone) {
        return specs.length == 0 ? FilterSpec.none() : new AnyFilterSpec(clone ? (FilterSpec[])specs.clone() : specs);
    }

    public static FilterSpec not(FilterSpec spec) {
        Assert.checkNotNullParam("spec", spec);
        return new NotFilterSpec(spec);
    }

    public static FilterSpec equal(String attribute, String value) {
        Assert.checkNotNullParam("attribute", attribute);
        Assert.checkNotNullParam("value", value);
        return new EqualsFilterSpec(attribute, AttributeValue.fromString(value));
    }

    public static FilterSpec equal(String attribute, byte[] value) {
        Assert.checkNotNullParam("attribute", attribute);
        Assert.checkNotNullParam("value", value);
        return new EqualsFilterSpec(attribute, AttributeValue.fromBytes(value));
    }

    public static FilterSpec substringMatch(String attribute, String initialPart, String finalPart) {
        Assert.checkNotNullParam("attribute", attribute);
        Assert.checkNotNullParam("initialPart", initialPart);
        Assert.checkNotNullParam("finalPart", finalPart);
        if (initialPart.isEmpty() && finalPart.isEmpty()) {
            return FilterSpec.hasAttribute(attribute);
        }
        return new SubstringFilterSpec(attribute, initialPart, finalPart);
    }

    public static FilterSpec approx(String attribute, String value) {
        Assert.checkNotNullParam("attribute", attribute);
        Assert.checkNotNullParam("value", value);
        return new EqualsFilterSpec(attribute, AttributeValue.fromString(value));
    }

    public static FilterSpec greaterOrEqual(String attribute, String value) {
        Assert.checkNotNullParam("attribute", attribute);
        Assert.checkNotNullParam("value", value);
        return new GreaterEqualFilterSpec(attribute, AttributeValue.fromString(value));
    }

    public static FilterSpec greaterOrEqual(String attribute, byte[] value) {
        Assert.checkNotNullParam("attribute", attribute);
        Assert.checkNotNullParam("value", value);
        return new GreaterEqualFilterSpec(attribute, AttributeValue.fromBytes(value));
    }

    public static FilterSpec lessOrEqual(String attribute, String value) {
        Assert.checkNotNullParam("attribute", attribute);
        Assert.checkNotNullParam("value", value);
        return new LessEqualFilterSpec(attribute, AttributeValue.fromString(value));
    }

    public static FilterSpec lessOrEqual(String attribute, byte[] value) {
        Assert.checkNotNullParam("attribute", attribute);
        Assert.checkNotNullParam("value", value);
        return new LessEqualFilterSpec(attribute, AttributeValue.fromBytes(value));
    }

    public static FilterSpec hasAttribute(String attribute) {
        Assert.checkNotNullParam("attribute", attribute);
        return new HasFilterSpec(attribute);
    }

    public static String escape(String str) {
        Assert.checkNotNullParam("str", str);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch != '*' && ch != '(' && ch != ')' && ch != '\\' && ch != '\u0000' && ch != '|' && ch != '=' && ch != '<' && ch != '>' && ch != '~' && ch != '/' && ch != '&') continue;
            StringBuilder b = new StringBuilder(str.length() + str.length() >> 2);
            FilterSpec.escapeTo(str, b);
            return b.toString();
        }
        return str;
    }

    public static void escapeTo(String str, StringBuilder b) {
        Assert.checkNotNullParam("str", str);
        Assert.checkNotNullParam("b", b);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '*' || ch == '(' || ch == ')' || ch == '\\' || ch == '\u0000' || ch == '|' || ch == '=' || ch == '<' || ch == '>' || ch == '~' || ch == '/' || ch == '&') {
                b.append('\\');
                int iv = ch >> 4;
                b.append(iv < 10 ? 48 + iv : 97 + iv - 10);
                iv = ch & 0xF;
                b.append(iv < 10 ? 48 + iv : 97 + iv - 10);
                continue;
            }
            b.append(ch);
        }
    }

    public final boolean equals(Object obj) {
        return obj instanceof FilterSpec && this.equals((FilterSpec)obj);
    }

    public abstract boolean equals(FilterSpec var1);

    public final String toString() {
        StringBuilder b = new StringBuilder(40);
        this.toString(b);
        return b.toString();
    }

    abstract void toString(StringBuilder var1);

    final Object writeReplace() {
        return new Serialized(this.toString());
    }

    public static interface Visitor<P, R, E extends Exception> {
        default public R handle(FilterSpec filterSpec, P parameter) throws E {
            return null;
        }

        default public R handle(EqualsFilterSpec filterSpec, P parameter) throws E {
            return this.handle((FilterSpec)filterSpec, parameter);
        }

        default public R handle(GreaterEqualFilterSpec filterSpec, P parameter) throws E {
            return this.handle((FilterSpec)filterSpec, parameter);
        }

        default public R handle(HasFilterSpec filterSpec, P parameter) throws E {
            return this.handle((FilterSpec)filterSpec, parameter);
        }

        default public R handle(LessEqualFilterSpec filterSpec, P parameter) throws E {
            return this.handle((FilterSpec)filterSpec, parameter);
        }

        default public R handle(AnyFilterSpec filterSpec, P parameter) throws E {
            return this.handle((FilterSpec)filterSpec, parameter);
        }

        default public R handle(AllFilterSpec filterSpec, P parameter) throws E {
            return this.handle((FilterSpec)filterSpec, parameter);
        }

        default public R handle(NotFilterSpec filterSpec, P parameter) throws E {
            return this.handle((FilterSpec)filterSpec, parameter);
        }

        default public R handle(SubstringFilterSpec filterSpec, P parameter) throws E {
            return this.handle((FilterSpec)filterSpec, parameter);
        }

        default public R handle(BooleanFilterSpec filterSpec, P parameter) throws E {
            return this.handle((FilterSpec)filterSpec, parameter);
        }
    }

    static class Serialized
    implements Serializable {
        private static final long serialVersionUID = 555689132344539984L;
        private final String string;

        Serialized(String string) {
            this.string = string;
        }

        public String getString() {
            return this.string;
        }

        final Object readResolve() {
            return FilterSpec.fromString(this.string);
        }
    }
}

