/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.List;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.service.BinaryRequirement;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.clustering.singleton.SingletonCacheRequirement;
import org.wildfly.clustering.singleton.SingletonDefaultCacheRequirement;
import org.wildfly.extension.clustering.singleton.SingletonExtension;
import org.wildfly.extension.clustering.singleton.SingletonSubsystemModel;

public class SingletonTransformersTestCase
extends AbstractSubsystemTest {
    public SingletonTransformersTestCase() {
        super("singleton", (Extension)new SingletonExtension());
    }

    private static String formatArtifact(String pattern, ModelTestControllerVersion version) {
        return String.format(pattern, version.getMavenGavVersion());
    }

    private static String formatEAP7SubsystemArtifact(ModelTestControllerVersion version) {
        return SingletonTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-singleton-extension:%s", version);
    }

    private static SingletonSubsystemModel getModelVersion(ModelTestControllerVersion controllerVersion) {
        switch (controllerVersion) {
            case EAP_7_4_0: {
                return SingletonSubsystemModel.VERSION_3_0_0;
            }
        }
        throw new IllegalArgumentException();
    }

    private static String[] getDependencies(ModelTestControllerVersion version) {
        switch (version) {
            case EAP_7_4_0: {
                return new String[]{SingletonTransformersTestCase.formatEAP7SubsystemArtifact(version), SingletonTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-api:%s", version), SingletonTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-common:%s", version), SingletonTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-server:%s", version), SingletonTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-service:%s", version), SingletonTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-singleton-api:%s", version), SingletonTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-spi:%s", version)};
            }
        }
        throw new IllegalArgumentException();
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require((UnaryRequirement)CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING, new String[]{"binding0", "binding1"}).require((UnaryRequirement)SingletonDefaultCacheRequirement.SINGLETON_SERVICE_BUILDER_FACTORY, new String[]{"singleton-container"}).require((BinaryRequirement)SingletonCacheRequirement.SINGLETON_SERVICE_BUILDER_FACTORY, "singleton-container", "singleton-cache").require((UnaryRequirement)SingletonDefaultCacheRequirement.SINGLETON_SERVICE_CONFIGURATOR_FACTORY, new String[]{"singleton-container"}).require((BinaryRequirement)SingletonCacheRequirement.SINGLETON_SERVICE_CONFIGURATOR_FACTORY, "singleton-container", "singleton-cache");
    }

    @Test
    public void testTransformerEAP740() throws Exception {
        this.testTransformation(ModelTestControllerVersion.EAP_7_4_0);
    }

    private void testTransformation(ModelTestControllerVersion controller) throws Exception {
        ModelVersion version = SingletonTransformersTestCase.getModelVersion(controller).getVersion();
        String[] dependencies = SingletonTransformersTestCase.getDependencies(controller);
        KernelServices services = this.buildKernelServices("subsystem-transform.xml", controller, version, dependencies);
        this.checkSubsystemModelTransformation(services, version, null, false);
    }

    @Test
    public void testRejectionsEAP740() throws Exception {
        this.testRejections(ModelTestControllerVersion.EAP_7_4_0);
    }

    private void testRejections(ModelTestControllerVersion controller) throws Exception {
        ModelVersion version = SingletonTransformersTestCase.getModelVersion(controller).getVersion();
        String[] dependencies = SingletonTransformersTestCase.getDependencies(controller);
        KernelServicesBuilder builder = this.createKernelServicesBuilder();
        builder.createLegacyKernelServicesBuilder(this.createAdditionalInitialization(), controller, version).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addMavenResourceURL(dependencies);
        KernelServices services = builder.build();
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        List xmlOps = builder.parseXmlResource("subsystem-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)version, (List)xmlOps, (FailedOperationTransformationConfig)SingletonTransformersTestCase.createFailedOperationConfig(version));
    }

    private static FailedOperationTransformationConfig createFailedOperationConfig(ModelVersion version) {
        return new FailedOperationTransformationConfig();
    }

    private KernelServicesBuilder createKernelServicesBuilder() {
        return this.createKernelServicesBuilder(this.createAdditionalInitialization());
    }

    private KernelServices buildKernelServices(String subsystemXml, ModelTestControllerVersion controllerVersion, ModelVersion version, String ... mavenResourceURLs) throws Exception {
        KernelServicesBuilder builder = this.createKernelServicesBuilder().setSubsystemXmlResource(subsystemXml);
        builder.createLegacyKernelServicesBuilder(this.createAdditionalInitialization(), controllerVersion, version).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addMavenResourceURL(mavenResourceURLs).skipReverseControllerCheck();
        KernelServices services = builder.build();
        Assert.assertTrue((String)(ModelTestControllerVersion.MASTER + " boot failed"), (boolean)services.isSuccessfulBoot());
        Assert.assertTrue((String)(controllerVersion.getMavenGavVersion() + " boot failed"), (boolean)((KernelServices)services.getLegacyServices(version)).isSuccessfulBoot());
        return services;
    }
}

