/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.routing;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.WebDeploymentRequirement;

public class LocalRouteServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator {
    private final SupplierDependency<String> route;

    public LocalRouteServiceConfigurator(String serverName, SupplierDependency<String> route) {
        super(ServiceNameFactory.parseServiceName((String)WebDeploymentRequirement.LOCAL_ROUTE.getName()).append(new String[]{serverName}));
        this.route = route;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer route = this.route.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(route, Function.identity(), this.route);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

