/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.session;

import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionIdGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.IdentifierMarshaller;

public class IdentifierSerializerTestCase {
    @Test
    public void testString() throws IOException {
        IdentifierSerializerTestCase.test((Marshaller<String, ByteBuffer>)IdentifierMarshaller.ISO_LATIN_1, () -> UUID.randomUUID().toString());
    }

    @Test
    public void testBase64() throws IOException {
        SecureRandomSessionIdGenerator generator = new SecureRandomSessionIdGenerator();
        IdentifierSerializerTestCase.test((Marshaller<String, ByteBuffer>)IdentifierMarshaller.BASE64, () -> IdentifierSerializerTestCase.lambda$testBase64$1((SessionIdGenerator)generator));
    }

    @Test
    public void testHex() throws IOException {
        IdentifierSerializerTestCase.test((Marshaller<String, ByteBuffer>)IdentifierMarshaller.HEX, () -> {
            byte[] buffer = new byte[16];
            int sessionIdLength = 16;
            StringBuilder builder = new StringBuilder(2 * sessionIdLength);
            int resultLenBytes = 0;
            Random random = new Random(System.currentTimeMillis());
            while (resultLenBytes < sessionIdLength) {
                random.nextBytes(buffer);
                for (int j = 0; j < buffer.length && resultLenBytes < sessionIdLength; ++resultLenBytes, ++j) {
                    byte b1 = (byte)((buffer[j] & 0xF0) >> 4);
                    byte b2 = (byte)(buffer[j] & 0xF);
                    if (b1 < 10) {
                        builder.append((char)(48 + b1));
                    } else {
                        builder.append((char)(65 + (b1 - 10)));
                    }
                    if (b2 < 10) {
                        builder.append((char)(48 + b2));
                        continue;
                    }
                    builder.append((char)(65 + (b2 - 10)));
                }
            }
            return builder.toString();
        });
    }

    private static void test(Marshaller<String, ByteBuffer> marshaller, Supplier<String> generator) throws IOException {
        for (int i = 0; i < 100; ++i) {
            String id = generator.get();
            ByteBuffer buffer = (ByteBuffer)marshaller.write((Object)id);
            Assert.assertEquals((Object)id, (Object)marshaller.read((Object)buffer));
        }
    }

    private static /* synthetic */ String lambda$testBase64$1(SessionIdGenerator generator) {
        return generator.createSessionId();
    }
}

