/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.session.oob;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;
import org.wildfly.clustering.web.session.oob.OOBSession;

public class OOBSessionTestCase {
    private final SessionManager<Object, Batch> manager = (SessionManager)Mockito.mock(SessionManager.class);
    private final String id = "ABC123";
    private final Object localContext = new Object();
    private final Session<Object> session = new OOBSession(this.manager, this.id, this.localContext);

    @Test
    public void getId() {
        Assert.assertSame((Object)this.id, (Object)this.session.getId());
    }

    @Test
    public void isValid() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertFalse((boolean)this.session.isValid());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn((Object)session);
        Assert.assertTrue((boolean)this.session.isValid());
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getMetaData() {
        SessionMetaData metaData = this.session.getMetaData();
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)metaData).getCreationTime());
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getAttributes() {
        SessionAttributes attributes = this.session.getAttributes();
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> ((SessionAttributes)attributes).getAttributeNames());
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void invalidate() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> this.session.invalidate());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        this.session.invalidate();
        ((Session)Mockito.verify((Object)session)).invalidate();
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void isNew() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).isNew());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        boolean expected = true;
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)expected);
        boolean result = this.session.getMetaData().isNew();
        Assert.assertEquals((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void isExpired() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).isExpired());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        boolean expected = true;
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isExpired()).thenReturn((Object)expected);
        boolean result = this.session.getMetaData().isExpired();
        Assert.assertEquals((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getCreationTime() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getCreationTime());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        Instant expected = Instant.now();
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getCreationTime()).thenReturn((Object)expected);
        Instant result = this.session.getMetaData().getCreationTime();
        Assert.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getLastAccessStartTime() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getLastAccessStartTime());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        Instant expected = Instant.now();
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getLastAccessStartTime()).thenReturn((Object)expected);
        Instant result = this.session.getMetaData().getLastAccessStartTime();
        Assert.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getLastAccessEndTime() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getLastAccessEndTime());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        Instant expected = Instant.now();
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getLastAccessEndTime()).thenReturn((Object)expected);
        Instant result = this.session.getMetaData().getLastAccessEndTime();
        Assert.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getMaxInactiveInterval() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getTimeout());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        Duration expected = Duration.ZERO;
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getTimeout()).thenReturn((Object)expected);
        Duration result = this.session.getMetaData().getTimeout();
        Assert.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void setLastAccess() {
        Assert.assertThrows(IllegalStateException.class, () -> this.session.getMetaData().setLastAccess(Instant.now(), Instant.now()));
    }

    @Test
    public void setTimeout() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Duration duration = Duration.ZERO;
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> this.session.getMetaData().setTimeout(duration));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        this.session.getMetaData().setTimeout(duration);
        ((SessionMetaData)Mockito.verify((Object)metaData)).setTimeout(duration);
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getAttributeNames() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> ((SessionAttributes)this.session.getAttributes()).getAttributeNames());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ImmutableSessionAttributes attributes = (ImmutableSessionAttributes)Mockito.mock(ImmutableSessionAttributes.class);
        Set<String> expected = Collections.singleton("foo");
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttributeNames()).thenReturn(expected);
        Set result = this.session.getAttributes().getAttributeNames();
        Assert.assertSame(expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getAttribute() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        String attributeName = "foo";
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> this.session.getAttributes().getAttribute(attributeName));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ImmutableSessionAttributes attributes = (ImmutableSessionAttributes)Mockito.mock(ImmutableSessionAttributes.class);
        Object expected = new Object();
        Mockito.when((Object)this.manager.readSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttribute(attributeName)).thenReturn(expected);
        Object result = this.session.getAttributes().getAttribute(attributeName);
        Assert.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void setAttribute() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        String attributeName = "foo";
        String attributeValue = "bar";
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> this.session.getAttributes().setAttribute(attributeName, attributeValue));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Object expected = new Object();
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.setAttribute(attributeName, (Object)attributeValue)).thenReturn(expected);
        Object result = this.session.getAttributes().setAttribute(attributeName, (Object)attributeValue);
        Assert.assertSame((Object)expected, (Object)result);
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void removeAttribute() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        String attributeName = "foo";
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> this.session.getAttributes().removeAttribute(attributeName));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Object expected = new Object();
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.removeAttribute(attributeName)).thenReturn(expected);
        Object result = this.session.getAttributes().removeAttribute(attributeName);
        Assert.assertSame((Object)expected, (Object)result);
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }
}

