/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.cfg.spi.IdUniquenessResolver;

public class HibernateCoreIdUniquenessResolver
implements IdUniquenessResolver {
    private final Set<Class<?>> entities;

    public HibernateCoreIdUniquenessResolver(Configuration cfg) {
        HashSet<Class> entities = new HashSet<Class>();
        Iterator iterator = cfg.getClassMappings();
        while (iterator.hasNext()) {
            entities.add(((PersistentClass)iterator.next()).getMappedClass());
        }
        this.entities = Collections.unmodifiableSet(entities);
    }

    public boolean areIdsUniqueForClasses(Class<?> entityInIndex, Class<?> otherEntityInIndex) {
        Class<?> rootOfOtherEntityInIndex;
        Class<?> rootOfEntityInIndex = this.getRootEntity(entityInIndex);
        return rootOfEntityInIndex == (rootOfOtherEntityInIndex = this.getRootEntity(otherEntityInIndex));
    }

    private Class<?> getRootEntity(Class<?> entityInIndex) {
        if (!this.entities.contains(entityInIndex)) {
            return entityInIndex;
        }
        Class<?> potentialParent = entityInIndex;
        do {
            if ((potentialParent = potentialParent.getSuperclass()) == null || potentialParent == Object.class || !this.entities.contains(potentialParent)) continue;
            entityInIndex = potentialParent;
        } while (potentialParent != null && potentialParent != Object.class);
        return entityInIndex;
    }
}

