/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;

class AddressSettingsValidator {
    static OperationStepHandler ADD_VALIDATOR = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String addressSetting = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            Resource hornetqServer = context.readResourceFromRoot(MessagingServices.getHornetQServerPathAddress(address), true);
            AddressSettingsValidator.checkExpiryAddress(context, operation, hornetqServer, addressSetting);
            AddressSettingsValidator.checkDeadLetterAddress(context, operation, hornetqServer, addressSetting);
            context.stepCompleted();
        }
    };

    AddressSettingsValidator() {
    }

    static void validateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        String addressSetting = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        Resource hornetqServer = context.readResourceFromRoot(MessagingServices.getHornetQServerPathAddress(address), true);
        AddressSettingsValidator.checkExpiryAddress(context, resource.getModel(), hornetqServer, addressSetting);
        AddressSettingsValidator.checkDeadLetterAddress(context, resource.getModel(), hornetqServer, addressSetting);
        context.stepCompleted();
    }

    private static void checkExpiryAddress(OperationContext context, ModelNode model, Resource hornetqServer, String addressSetting) throws OperationFailedException {
        ModelNode expiryAddress = CommonAttributes.EXPIRY_ADDRESS.resolveModelAttribute(context, model);
        if (!AddressSettingsValidator.findMatchingResource(expiryAddress, hornetqServer)) {
            MessagingLogger.MESSAGING_LOGGER.noMatchingExpiryAddress(expiryAddress.asString(), addressSetting);
        }
    }

    private static void checkDeadLetterAddress(OperationContext context, ModelNode model, Resource hornetqServer, String addressSetting) throws OperationFailedException {
        ModelNode deadLetterAddress = CommonAttributes.DEAD_LETTER_ADDRESS.resolveModelAttribute(context, model);
        if (!AddressSettingsValidator.findMatchingResource(deadLetterAddress, hornetqServer)) {
            MessagingLogger.MESSAGING_LOGGER.noMatchingDeadLetterAddress(deadLetterAddress.asString(), addressSetting);
        }
    }

    private static boolean findMatchingResource(ModelNode addressNode, Resource hornetqServer) {
        String addressPrefix;
        String childType;
        if (!addressNode.isDefined()) {
            return true;
        }
        String address = addressNode.asString();
        if (address.startsWith("jms.queue.")) {
            childType = "jms-queue";
            addressPrefix = "jms.queue.";
        } else if (address.startsWith("jms.topic.")) {
            childType = "jms-topic";
            addressPrefix = "jms.topic.";
        } else {
            childType = "core-queue";
            addressPrefix = "";
        }
        for (String childName : hornetqServer.getChildrenNames(childType)) {
            if (!address.equals(addressPrefix + childName)) continue;
            return true;
        }
        return false;
    }
}

