/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.regex.Pattern;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.logging.Filters;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;

final class Transformers1_1_0 {
    static final DiscardAttributeChecker DISCARD_ENABLED = new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(true)});
    static final AttributeConverter CONSOLE_COLOR_CONVERTER = new ConsoleColorFormatPatternConverter();
    static final AttributeConverter FILTER_SPEC_CONVERTER = new FilterSpecAttributeConverter();
    static final DiscardAttributeChecker LEVEL_ALL_DISCARD_CHECKER = new LevelAllDiscardAttributeChecker();
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");

    private Transformers1_1_0() {
    }

    private static boolean isExpression(ModelNode attributeValue) {
        return attributeValue.getType() == ModelType.EXPRESSION || attributeValue.getType() == ModelType.STRING && EXPRESSION_PATTERN.matcher(attributeValue.asString()).matches();
    }

    private static class LevelAllDiscardAttributeChecker
    extends DiscardAttributeChecker.DefaultDiscardAttributeChecker {
        private LevelAllDiscardAttributeChecker() {
            super(false, false);
        }

        protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return attributeValue.isDefined() && attributeValue.asString().equalsIgnoreCase("ALL");
        }
    }

    private static class FilterSpecAttributeConverter
    extends AttributeConverter.DefaultAttributeConverter {
        private FilterSpecAttributeConverter() {
        }

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined() && !Transformers1_1_0.isExpression(attributeValue)) {
                String filterExpression = attributeValue.asString();
                attributeValue.set(Filters.filterSpecToFilter(filterExpression));
            }
        }
    }

    private static class ConsoleColorFormatPatternConverter
    extends AttributeConverter.DefaultAttributeConverter {
        private ConsoleColorFormatPatternConverter() {
        }

        private static String fixFormatPattern(String currentPattern) {
            return currentPattern.replaceAll("(%K\\{[a-zA-Z]*?})", "");
        }

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.getType() == ModelType.STRING) {
                String currentPattern = attributeValue.asString();
                attributeValue.set(ConsoleColorFormatPatternConverter.fixFormatPattern(currentPattern));
            } else if (attributeValue.getType() == ModelType.EXPRESSION) {
                String currentPattern = attributeValue.asString();
                attributeValue.set(new ValueExpression(ConsoleColorFormatPatternConverter.fixFormatPattern(currentPattern)));
            }
        }
    }
}

