/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class FixedLengthStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit>
implements StreamSourceConduit {
    private long remaining;

    public FixedLengthStreamSourceConduit(StreamSourceConduit next, long remaining) {
        super(next);
        this.remaining = remaining;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long length = this.remaining;
        if (length > 0L) {
            long res = ((StreamSourceConduit)this.next).transferTo(position, Math.min(count, length), target);
            if (res > 0L) {
                this.remaining = length - res;
            }
            return res;
        }
        return 0L;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long length = this.remaining;
        if (length > 0L) {
            long res = ((StreamSourceConduit)this.next).transferTo(Math.min(count, length), throughBuffer, target);
            if (res > 0L) {
                this.remaining = length - res;
            }
            return res;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int res;
        int limit = dst.limit();
        int pos = dst.position();
        long length = this.remaining;
        if (length == 0L) {
            return -1;
        }
        if ((long)(limit - pos) > length) {
            dst.limit(pos + (int)length);
            try {
                res = ((StreamSourceConduit)this.next).read(dst);
            }
            finally {
                dst.limit(limit);
            }
        } else {
            res = ((StreamSourceConduit)this.next).read(dst);
        }
        if ((long)res > 0L) {
            this.remaining = length - (long)res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        long res2;
        if (len == 0) {
            return 0L;
        }
        if (len == 1) {
            return this.read(dsts[offs]);
        }
        long length = this.remaining;
        if (length == 0L) {
            return -1L;
        }
        long t = 0L;
        int i = 0;
        while ((long)i < length) {
            ByteBuffer buffer = dsts[i + offs];
            int lim = buffer.limit();
            if ((t += (long)(lim - buffer.position())) > length) {
                buffer.limit(lim - (int)(t - length));
                try {
                    long res2 = ((StreamSourceConduit)this.next).read(dsts, offs, i + 1);
                    if (res2 > 0L) {
                        this.remaining = length - res2;
                    }
                    long l = res2;
                    return l;
                }
                finally {
                    buffer.limit(lim);
                }
            }
            ++i;
        }
        long l = res2 = t == 0L ? 0L : ((StreamSourceConduit)this.next).read(dsts, offs, len);
        if (res2 > 0L) {
            this.remaining = length - res2;
        }
        return res2;
    }

    public long getRemaining() {
        return this.remaining;
    }
}

