/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.ProcessReloadHandler;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public class HostProcessReloadHandler
extends ProcessReloadHandler<HostRunningModeControl> {
    private static final AttributeDefinition RESTART_SERVERS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("restart-servers", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).build();
    private static final AttributeDefinition USE_CURRENT_DOMAIN_CONFIG = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-current-domain-config", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).build();
    private static final AttributeDefinition USE_CURRENT_HOST_CONFIG = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-current-host-config", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).build();
    private static final AttributeDefinition[] MASTER_ATTRIBUTES = new AttributeDefinition[]{ADMIN_ONLY, RESTART_SERVERS, USE_CURRENT_DOMAIN_CONFIG, USE_CURRENT_HOST_CONFIG};
    private static final AttributeDefinition[] SLAVE_ATTRIBUTES = new AttributeDefinition[]{ADMIN_ONLY, RESTART_SERVERS, USE_CURRENT_HOST_CONFIG};

    public static OperationDefinition getDefinition(LocalHostControllerInfo hostControllerInfo) {
        return new DeferredParametersOperationDefinitionBuilder(hostControllerInfo, "reload", (ResourceDescriptionResolver)HostModelUtil.getResourceDescriptionResolver(new String[0])).setParameters(hostControllerInfo.isMasterDomainController() ? MASTER_ATTRIBUTES : SLAVE_ATTRIBUTES).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).setRuntimeOnly().build();
    }

    public HostProcessReloadHandler(ServiceName rootService, HostRunningModeControl runningModeControl, ControlledProcessState processState) {
        super(rootService, (RunningModeControl)runningModeControl, processState);
    }

    protected ProcessReloadHandler.ReloadContext<HostRunningModeControl> initializeReloadContext(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean adminOnly = ADMIN_ONLY.resolveModelAttribute(context, operation).asBoolean(false);
        final boolean restartServers = RESTART_SERVERS.resolveModelAttribute(context, operation).asBoolean(true);
        final boolean useCurrentHostConfig = USE_CURRENT_HOST_CONFIG.resolveModelAttribute(context, operation).asBoolean(true);
        final boolean useCurrentDomainConfig = USE_CURRENT_DOMAIN_CONFIG.resolveModelAttribute(context, operation).asBoolean(true);
        return new ProcessReloadHandler.ReloadContext<HostRunningModeControl>(){

            public void reloadInitiated(HostRunningModeControl runningModeControl) {
                runningModeControl.setRestartMode(restartServers ? RestartMode.SERVERS : RestartMode.HC_ONLY);
            }

            public void doReload(HostRunningModeControl runningModeControl) {
                runningModeControl.setRunningMode(adminOnly ? RunningMode.ADMIN_ONLY : RunningMode.NORMAL);
                runningModeControl.setReloaded();
                runningModeControl.setUseCurrentConfig(useCurrentHostConfig);
                runningModeControl.setUseCurrentDomainConfig(useCurrentDomainConfig);
            }
        };
    }

    private static class DeferredParametersOperationDefinitionBuilder
    extends SimpleOperationDefinitionBuilder {
        private final LocalHostControllerInfo hostControllerInfo;

        public DeferredParametersOperationDefinitionBuilder(LocalHostControllerInfo hostControllerInfo, String name, ResourceDescriptionResolver resolver) {
            super(name, resolver);
            this.hostControllerInfo = hostControllerInfo;
        }

        public SimpleOperationDefinition internalBuild(final ResourceDescriptionResolver resolver, final ResourceDescriptionResolver attributeResolver) {
            return new SimpleOperationDefinition(this.name, resolver, attributeResolver, this.entryType, this.flags, this.replyType, this.replyValueType, false, this.deprecationData, this.replyParameters, this.parameters){

                public DescriptionProvider getDescriptionProvider() {
                    return new DescriptionProvider(){

                        public ModelNode getModelDescription(Locale locale) {
                            AttributeDefinition[] params = hostControllerInfo.isMasterDomainController() ? MASTER_ATTRIBUTES : SLAVE_ATTRIBUTES;
                            return new DefaultOperationDescriptionProvider(this.getName(), resolver, attributeResolver, replyType, replyValueType, replyAllowNull, deprecationData, replyParameters, params, accessConstraints).getModelDescription(locale);
                        }
                    };
                }
            };
        }
    }
}

