/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.remote.DefaultEjbClientContextService;
import org.jboss.as.ejb3.remote.TCCLEJBClientContextSelectorService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class EjbClientContextSetupProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EjbClientContextSetupProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        RegistractionService registractionService = new RegistractionService(module);
        ServiceName registrationServiceName = deploymentUnit.getServiceName().append(new String[]{"ejb3", "client-context", "registration-service"});
        phaseContext.getServiceTarget().addService(registrationServiceName, (Service)registractionService).addDependency(this.getEJBClientContextServiceName(phaseContext), EJBClientContext.class, registractionService.ejbClientContextInjectedValue).addDependency(TCCLEJBClientContextSelectorService.TCCL_BASED_EJB_CLIENT_CONTEXT_SELECTOR_SERVICE_NAME, TCCLEJBClientContextSelectorService.class, registractionService.tcclEJBClientContextSelectorServiceController).install();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            component.addDependency(registrationServiceName, ServiceBuilder.DependencyType.REQUIRED);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }

    private ServiceName getEJBClientContextServiceName(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parentDeploymentUnit = deploymentUnit.getParent();
        ServiceName serviceName = parentDeploymentUnit != null ? (ServiceName)parentDeploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME) : (ServiceName)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME);
        if (serviceName != null) {
            return serviceName;
        }
        return DefaultEjbClientContextService.DEFAULT_SERVICE_NAME;
    }

    private static final class RegistractionService
    implements Service<Void> {
        private final Module module;
        final InjectedValue<TCCLEJBClientContextSelectorService> tcclEJBClientContextSelectorServiceController = new InjectedValue();
        final InjectedValue<EJBClientContext> ejbClientContextInjectedValue = new InjectedValue();

        private RegistractionService(Module module) {
            this.module = module;
        }

        public void start(StartContext context) throws StartException {
            EJBClientContext ejbClientContext = (EJBClientContext)this.ejbClientContextInjectedValue.getValue();
            TCCLEJBClientContextSelectorService tcclBasedEJBClientContextSelector = (TCCLEJBClientContextSelectorService)this.tcclEJBClientContextSelectorServiceController.getValue();
            logger.debugf("Registering EJB client context %s for classloader %s", (Object)ejbClientContext, (Object)this.module.getClassLoader());
            tcclBasedEJBClientContextSelector.registerEJBClientContext(ejbClientContext, (ClassLoader)this.module.getClassLoader());
        }

        public void stop(StopContext context) {
            TCCLEJBClientContextSelectorService tcclBasedEJBClientContextSelector = (TCCLEJBClientContextSelectorService)this.tcclEJBClientContextSelectorServiceController.getValue();
            logger.debugf("unRegistering EJB client context for classloader %s", (Object)this.module.getClassLoader());
            tcclBasedEJBClientContextSelector.unRegisterEJBClientContext((ClassLoader)this.module.getClassLoader());
        }

        public Void getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }
    }
}

