/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.cors;

import javax.servlet.http.HttpServletRequest;

public enum CORSRequestType {
    ACTUAL,
    PREFLIGHT,
    OTHER;


    public static CORSRequestType detect(HttpServletRequest request) {
        if (request.getHeader("Origin") == null) {
            return OTHER;
        }
        String serverOrigin = request.getScheme() + "://" + request.getHeader("Host");
        if (request.getHeader("Host") != null && request.getHeader("Origin").equals(serverOrigin)) {
            return OTHER;
        }
        if (request.getHeader("Access-Control-Request-Method") != null && request.getMethod() != null && request.getMethod().equalsIgnoreCase("OPTIONS")) {
            return PREFLIGHT;
        }
        return ACTUAL;
    }
}

