/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Filter;
import org.hibernate.search.query.dsl.SpatialContext;
import org.hibernate.search.query.dsl.SpatialMatchingContext;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.query.dsl.WithinContext;
import org.hibernate.search.query.dsl.impl.ConnectedSpatialMatchingContext;
import org.hibernate.search.query.dsl.impl.ConnectedWithinContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.SpatialQueryContext;

public class ConnectedSpatialContext
implements SpatialContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final SpatialQueryContext spatialContext;

    public ConnectedSpatialContext(QueryBuildingContext context) {
        this.queryContext = context;
        this.queryCustomizer = new QueryCustomizer();
        this.queryCustomizer.withConstantScore();
        this.spatialContext = new SpatialQueryContext();
    }

    @Override
    public SpatialMatchingContext onField(String fieldName) {
        this.spatialContext.setCoordinatesField(fieldName);
        return new ConnectedSpatialMatchingContext(this.queryContext, this.queryCustomizer, this.spatialContext);
    }

    @Override
    public SpatialContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    @Override
    public SpatialContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    @Override
    public SpatialContext filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }

    @Override
    public WithinContext within(double distance, Unit unit) {
        this.spatialContext.setRadius(distance, unit);
        return new ConnectedWithinContext(this);
    }

    QueryBuildingContext getQueryContext() {
        return this.queryContext;
    }

    QueryCustomizer getQueryCustomizer() {
        return this.queryCustomizer;
    }

    SpatialQueryContext getSpatialContext() {
        return this.spatialContext;
    }
}

