/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.AdvancedCacheConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ConsistentHashStrategy;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheAddHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class DistributedCacheAddHandler
extends SharedStateCacheAddHandler {
    DistributedCacheAddHandler() {
        super(CacheMode.DIST_SYNC);
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        super.populateModel(operation, model);
        for (AttributeDefinition attribute : DistributedCacheResourceDefinition.ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode containerModel, ModelNode cache, AdvancedCacheConfigurationBuilder configBuilder) throws OperationFailedException {
        super.processModelNode(context, containerName, containerModel, cache, configBuilder);
        ConfigurationBuilder builder = configBuilder.getConfigurationBuilder();
        configBuilder.setConsistentHashStrategy(ConsistentHashStrategy.valueOf(DistributedCacheResourceDefinition.CONSISTENT_HASH_STRATEGY.resolveModelAttribute(context, cache).asString()));
        builder.clustering().hash().numOwners(DistributedCacheResourceDefinition.OWNERS.resolveModelAttribute(context, cache).asInt()).numSegments(DistributedCacheResourceDefinition.SEGMENTS.resolveModelAttribute(context, cache).asInt()).capacityFactor(ModelNodes.asFloat((ModelNode)DistributedCacheResourceDefinition.CAPACITY_FACTOR.resolveModelAttribute(context, cache)));
        long lifespan = DistributedCacheResourceDefinition.L1_LIFESPAN.resolveModelAttribute(context, cache).asLong();
        if (lifespan > 0L) {
            builder.clustering().l1().enable().lifespan(lifespan);
        } else {
            builder.clustering().l1().disable();
        }
    }
}

