/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.remoting.ConnectorCommon;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.HttpConnectorResource;
import org.jboss.as.remoting.LocalOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.PropertyResource;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingSubsystem10Parser;
import org.jboss.as.remoting.RemotingSubsystem11Parser;
import org.jboss.as.remoting.RemotingSubsystem20Parser;
import org.jboss.as.remoting.RemotingSubsystem30Parser;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.RemotingSubsystemXMLPersister;
import org.jboss.as.remoting.SaslPolicyResource;
import org.jboss.as.remoting.SaslResource;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class RemotingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "remoting";
    private static final String RESOURCE_NAME = RemotingExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final String NODE_NAME_PROPERTY = "jboss.node.name";
    static final SensitivityClassification REMOTING_SECURITY = new SensitivityClassification("remoting", "remoting-security", false, true, true);
    static final SensitiveTargetAccessConstraintDefinition REMOTING_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(REMOTING_SECURITY);
    private static final int MANAGEMENT_API_MAJOR_VERSION = 3;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ModelVersion CURRENT_VERSION = ModelVersion.create((int)3, (int)0, (int)0);
    private static final ModelVersion VERSION_1_3 = ModelVersion.create((int)1, (int)3);
    private static final ModelVersion VERSION_2_1 = ModelVersion.create((int)2, (int)1);

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, RemotingExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_VERSION);
        registration.registerXMLElementWriter((XMLElementWriter)RemotingSubsystemXMLPersister.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel((ResourceDefinition)new RemotingSubsystemRootResource());
        subsystem.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)RemotingEndpointResource.INSTANCE);
        ManagementResourceRegistration connector = subsystem.registerSubModel((ResourceDefinition)ConnectorResource.INSTANCE);
        connector.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_CONNECTOR);
        ManagementResourceRegistration sasl = connector.registerSubModel((ResourceDefinition)SaslResource.INSTANCE_CONNECTOR);
        sasl.registerSubModel((ResourceDefinition)SaslPolicyResource.INSTANCE_CONNECTOR);
        sasl.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_CONNECTOR);
        ManagementResourceRegistration httpConnector = subsystem.registerSubModel((ResourceDefinition)HttpConnectorResource.INSTANCE);
        httpConnector.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_HTTP_CONNECTOR);
        ManagementResourceRegistration httpSasl = httpConnector.registerSubModel((ResourceDefinition)SaslResource.INSTANCE_HTTP_CONNECTOR);
        httpSasl.registerSubModel((ResourceDefinition)SaslPolicyResource.INSTANCE_HTTP_CONNECTOR);
        httpSasl.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_HTTP_CONNECTOR);
        subsystem.registerSubModel((ResourceDefinition)RemoteOutboundConnectionResourceDefinition.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)LocalOutboundConnectionResourceDefinition.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)new GenericOutboundConnectionResourceDefinition());
        if (context.isRegisterTransformers()) {
            this.registerTransformers(registration);
        }
    }

    private void registerTransformers(SubsystemRegistration registration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getSubsystemVersion());
        this.buildTransformers_2_1(chainedBuilder.createBuilder(registration.getSubsystemVersion(), VERSION_2_1));
        this.buildTransformers_1_3(chainedBuilder.createBuilder(VERSION_2_1, VERSION_1_3));
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{VERSION_1_3, VERSION_2_1}});
    }

    private void buildTransformers_1_3(ResourceTransformationDescriptionBuilder builder) {
        builder.rejectChildResource(HttpConnectorResource.PATH);
        RemotingExtension.endpointTransform(builder);
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(RemoteOutboundConnectionResourceDefinition.ADDRESS).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(Protocol.REMOTE.toString())}), new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.PROTOCOL});
    }

    private void buildTransformers_2_1(ResourceTransformationDescriptionBuilder builder) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(ConnectorResource.PATH).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{ConnectorCommon.SASL_PROTOCOL.getDefaultValue()}), new AttributeDefinition[]{ConnectorCommon.SASL_PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SERVER_NAME});
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(HttpConnectorResource.PATH).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{ConnectorCommon.SASL_PROTOCOL.getDefaultValue()}), new AttributeDefinition[]{ConnectorCommon.SASL_PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SERVER_NAME});
    }

    private static ResourceTransformationDescriptionBuilder endpointTransform(ResourceTransformationDescriptionBuilder parent) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)parent.addChildResource(RemotingEndpointResource.ENDPOINT_PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, RemotingEndpointResource.ATTRIBUTES)).addRejectCheck(RejectAttributeChecker.DEFINED, RemotingEndpointResource.ATTRIBUTES.toArray(new AttributeDefinition[RemotingEndpointResource.ATTRIBUTES.size()]))).end().addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer(OperationTransformer.DISCARD).end().setCustomResourceTransformer(ResourceTransformer.DISCARD);
        return parent;
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_0.getUriString(), (XMLElementReader)RemotingSubsystem10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_1.getUriString(), (XMLElementReader)RemotingSubsystem11Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_2_0.getUriString(), (XMLElementReader)RemotingSubsystem20Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_3_0.getUriString(), (XMLElementReader)RemotingSubsystem30Parser.INSTANCE);
    }
}

