/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.constExpr;

import com.sun.tools.corba.se.idl.Util;
import com.sun.tools.corba.se.idl.constExpr.BinaryExpr;
import com.sun.tools.corba.se.idl.constExpr.EvaluationException;
import com.sun.tools.corba.se.idl.constExpr.Expression;
import java.math.BigInteger;

public class ShiftLeft
extends BinaryExpr {
    protected ShiftLeft(Expression leftOperand, Expression rightOperand) {
        super("<<", leftOperand, rightOperand);
    }

    @Override
    public Object evaluate() throws EvaluationException {
        try {
            Number l = (Number)this.left().evaluate();
            Number r = (Number)this.right().evaluate();
            if (l instanceof Float || l instanceof Double || r instanceof Float || r instanceof Double) {
                String[] parameters = new String[]{Util.getMessage("EvaluationException.left"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
                throw new EvaluationException(Util.getMessage("EvaluationException.1", parameters));
            }
            BigInteger bL = (BigInteger)this.coerceToTarget(l);
            BigInteger bR = (BigInteger)r;
            BigInteger ls = bL.shiftLeft(bR.intValue());
            if (this.type().indexOf("short") >= 0) {
                ls = ls.mod(twoPow16);
            } else if (this.type().indexOf("long") >= 0) {
                ls = ls.mod(twoPow32);
            } else if (this.type().indexOf("long long") >= 0) {
                ls = ls.mod(twoPow64);
            }
            this.value(this.coerceToTarget(ls));
        }
        catch (ClassCastException e) {
            String[] parameters = new String[]{Util.getMessage("EvaluationException.left"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
            throw new EvaluationException(Util.getMessage("EvaluationException.1", parameters));
        }
        return this.value();
    }
}

