/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.logging;

import java.net.URL;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYCLJG", length=4)
public interface JGroupsLogger
extends BasicLogger {
    public static final String ROOT_LOGGER_CATEGORY = "org.jboss.as.clustering.jgroups";
    public static final JGroupsLogger ROOT_LOGGER = (JGroupsLogger)Logger.getMessageLogger(JGroupsLogger.class, (String)"org.jboss.as.clustering.jgroups");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating JGroups subsystem.")
    public void activatingSubsystem();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=2, value="Setting %s.%s=%d")
    public void setProtocolPropertyValue(String var1, String var2, Object var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=3, value="Failed to set non-existent %s.%s=%d")
    public void nonExistentProtocolPropertyValue(@Cause Throwable var1, String var2, String var3, Object var4);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=4, value="Could not set %s.%s and %s.%s, %s socket binding does not specify a multicast socket")
    public void couldNotSetAddressAndPortNoMulticastSocket(@Cause Throwable var1, String var2, String var3, String var4, String var5, String var6);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Error accessing original value for property %s of protocol %s")
    public void unableToAccessProtocolPropertyValue(@Cause Throwable var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="property %s for protocol %s attempting to override socket binding value %s : property value %s will be ignored")
    public void unableToOverrideSocketBindingValue(String var1, String var2, String var3, Object var4);

    @Message(id=7, value="Failed to parse %s")
    public String parserFailure(URL var1);

    @Message(id=8, value="Failed to locate %s")
    public String notFound(String var1);

    @Message(id=9, value="A node named %s already exists in this cluster. Perhaps there is already a server running on this host? If so, restart this server with a unique node name, via -Djboss.node.name=<node-name>")
    public IllegalStateException duplicateNodeName(String var1);

    @Message(id=10, value="Transport for stack %s is not defined. Please specify both a transport and protocol list, either as optional parameters to add() or via batching.")
    public OperationFailedException transportNotDefined(String var1);

    @Message(id=11, value="Protocol list for stack %s is not defined. Please specify both a transport and protocol list, either as optional parameters to add() or via batching.")
    public OperationFailedException protocolListNotDefined(String var1);

    @Message(id=12, value="Protocol with relative path %s is already defined.")
    public OperationFailedException protocolAlreadyDefined(String var1);

    @Message(id=13, value="Protocol with relative path %s is not defined.")
    public OperationFailedException protocolNotDefined(String var1);

    @Message(id=14, value="Property %s for protocol with relative path %s is not defined.")
    public OperationFailedException propertyNotDefined(String var1, String var2);

    @Message(id=15, value="Unknown metric %s")
    public String unknownMetric(String var1);

    @Message(id=16, value="Unable to load protocol class %s")
    public OperationFailedException unableToLoadProtocolClass(String var1);

    @Message(id=17, value="Privileged access exception on attribute/method %s")
    public String privilegedAccessExceptionForAttribute(String var1);

    @Message(id=18, value="Instantiation exception on converter for attribute/method %s")
    public String instantiationExceptionOnConverterForAttribute(String var1);

    @Message(id=19, value="Protocol %s not found in current stack")
    public String protocolNotFoundInStack(String var1);

    @Message(id=20, value="Unable to load protocol class %s")
    public String unableToLoadProtocol(String var1);

    @Message(id=21, value="Attributes referencing threads subsystem can only be used to support older slaves in the domain.")
    public String threadsAttributesUsedInRuntime();
}

